/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.optimizations.QueryCardinalityUtil;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.Patterns;

public class RemoveRedundantCrossJoin
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join().matching(JoinNode::isCrossJoin);

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(JoinNode node, Captures captures, Rule.Context context) {
        if (node.getRight().getOutputSymbols().isEmpty() && QueryCardinalityUtil.isScalar(node.getRight(), context.getLookup())) {
            return Rule.Result.ofPlanNode(node.getLeft());
        }
        if (node.getLeft().getOutputSymbols().isEmpty() && QueryCardinalityUtil.isScalar(node.getLeft(), context.getLookup())) {
            return Rule.Result.ofPlanNode(node.getRight());
        }
        return Rule.Result.empty();
    }
}

