/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.optimizations.QueryCardinalityUtil;
import io.prestosql.sql.planner.plan.ApplyNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.ExistsPredicate;
import io.prestosql.sql.tree.Expression;

public class RemoveRedundantExists
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode().matching(node -> node.getSubqueryAssignments().getExpressions().stream().allMatch(expression -> expression instanceof ExistsPredicate && ((ExistsPredicate)expression).getSubquery().equals((Object)BooleanLiteral.TRUE_LITERAL)));

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ApplyNode node, Captures captures, Rule.Context context) {
        BooleanLiteral result;
        Assignments.Builder assignments = Assignments.builder();
        assignments.putIdentities(node.getInput().getOutputSymbols());
        if (QueryCardinalityUtil.isEmpty(node.getSubquery(), context.getLookup())) {
            result = BooleanLiteral.FALSE_LITERAL;
        } else if (QueryCardinalityUtil.isAtLeastScalar(node.getSubquery(), context.getLookup())) {
            result = BooleanLiteral.TRUE_LITERAL;
        } else {
            return Rule.Result.empty();
        }
        for (Symbol output : node.getSubqueryAssignments().getOutputs()) {
            assignments.put(output, (Expression)result);
        }
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), node.getInput(), assignments.build()));
    }
}

