/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.optimizations.PlanNodeSearcher;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.CorrelatedJoinNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.BooleanLiteral;
import java.util.List;

public class TransformCorrelatedSingleRowSubqueryToProject
implements Rule<CorrelatedJoinNode> {
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin().with(Patterns.CorrelatedJoin.filter().equalTo((Object)BooleanLiteral.TRUE_LITERAL));

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode parent, Captures captures, Rule.Context context) {
        List values = PlanNodeSearcher.searchFrom(parent.getSubquery(), context.getLookup()).recurseOnlyWhen(ProjectNode.class::isInstance).where(ValuesNode.class::isInstance).findAll();
        if (values.size() != 1 || !TransformCorrelatedSingleRowSubqueryToProject.isSingleRowValuesWithNoColumns((ValuesNode)values.get(0))) {
            return Rule.Result.empty();
        }
        List subqueryProjections = PlanNodeSearcher.searchFrom(parent.getSubquery(), context.getLookup()).where(node -> node instanceof ProjectNode && !node.getOutputSymbols().equals(parent.getCorrelation())).findAll();
        if (subqueryProjections.size() == 0) {
            return Rule.Result.ofPlanNode(parent.getInput());
        }
        if (subqueryProjections.size() == 1) {
            Assignments assignments = Assignments.builder().putIdentities(parent.getInput().getOutputSymbols()).putAll(((ProjectNode)subqueryProjections.get(0)).getAssignments()).build();
            return Rule.Result.ofPlanNode(this.projectNode(parent.getInput(), assignments, context));
        }
        return Rule.Result.empty();
    }

    private ProjectNode projectNode(PlanNode source, Assignments assignments, Rule.Context context) {
        return new ProjectNode(context.getIdAllocator().getNextId(), source, assignments);
    }

    private static boolean isSingleRowValuesWithNoColumns(ValuesNode values) {
        return values.getRowCount() == 1 && values.getOutputSymbols().isEmpty();
    }
}

