/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.DeterminismEvaluator;
import io.prestosql.sql.planner.DomainTranslator;
import io.prestosql.sql.planner.EffectivePredicateExtractor;
import io.prestosql.sql.planner.EqualityInference;
import io.prestosql.sql.planner.ExpressionInterpreter;
import io.prestosql.sql.planner.ExpressionSymbolInliner;
import io.prestosql.sql.planner.LiteralEncoder;
import io.prestosql.sql.planner.NoOpSymbolResolver;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.rule.CanonicalizeExpressionRewriter;
import io.prestosql.sql.planner.iterative.rule.UnwrapCastInComparison;
import io.prestosql.sql.planner.optimizations.ExpressionEquivalence;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.AssignUniqueId;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.GroupIdNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.MarkDistinctNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.SampleNode;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import io.prestosql.sql.planner.plan.SimplePlanRewriter;
import io.prestosql.sql.planner.plan.SortNode;
import io.prestosql.sql.planner.plan.SpatialJoinNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.plan.UnionNode;
import io.prestosql.sql.planner.plan.UnnestNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.tree.BetweenPredicate;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Literal;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.sql.tree.TryExpression;
import io.prestosql.sql.util.AstUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PredicatePushDown
implements PlanOptimizer {
    private static final Set<ComparisonExpression.Operator> DYNAMIC_FILTERING_SUPPORTED_COMPARISONS = ImmutableSet.of((Object)ComparisonExpression.Operator.EQUAL, (Object)ComparisonExpression.Operator.GREATER_THAN, (Object)ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Object)ComparisonExpression.Operator.LESS_THAN, (Object)ComparisonExpression.Operator.LESS_THAN_OR_EQUAL);
    private final Metadata metadata;
    private final TypeOperators typeOperators;
    private final LiteralEncoder literalEncoder;
    private final TypeAnalyzer typeAnalyzer;
    private final boolean useTableProperties;
    private final boolean dynamicFiltering;

    public PredicatePushDown(Metadata metadata, TypeOperators typeOperators, TypeAnalyzer typeAnalyzer, boolean useTableProperties, boolean dynamicFiltering) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.literalEncoder = new LiteralEncoder(metadata);
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        this.useTableProperties = useTableProperties;
        this.dynamicFiltering = dynamicFiltering;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        EffectivePredicateExtractor effectivePredicateExtractor = new EffectivePredicateExtractor(new DomainTranslator(this.metadata), this.metadata, this.useTableProperties && SystemSessionProperties.isPredicatePushdownUseTableProperties(session));
        return SimplePlanRewriter.rewriteWith(new Rewriter(symbolAllocator, idAllocator, this.metadata, this.typeOperators, this.literalEncoder, effectivePredicateExtractor, this.typeAnalyzer, session, types, this.dynamicFiltering), plan, BooleanLiteral.TRUE_LITERAL);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Expression> {
        private final SymbolAllocator symbolAllocator;
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final TypeOperators typeOperators;
        private final LiteralEncoder literalEncoder;
        private final EffectivePredicateExtractor effectivePredicateExtractor;
        private final TypeAnalyzer typeAnalyzer;
        private final Session session;
        private final TypeProvider types;
        private final ExpressionEquivalence expressionEquivalence;
        private final boolean dynamicFiltering;

        private Rewriter(SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, TypeOperators typeOperators, LiteralEncoder literalEncoder, EffectivePredicateExtractor effectivePredicateExtractor, TypeAnalyzer typeAnalyzer, Session session, TypeProvider types, boolean dynamicFiltering) {
            this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
            this.literalEncoder = Objects.requireNonNull(literalEncoder, "literalEncoder is null");
            this.effectivePredicateExtractor = Objects.requireNonNull(effectivePredicateExtractor, "effectivePredicateExtractor is null");
            this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.expressionEquivalence = new ExpressionEquivalence(metadata, typeAnalyzer);
            this.dynamicFiltering = dynamicFiltering;
        }

        @Override
        public PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            PlanNode rewrittenNode = context.defaultRewrite(node, (Expression)BooleanLiteral.TRUE_LITERAL);
            if (!context.get().equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, context.get());
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitExchange(ExchangeNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            boolean modified = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                HashMap<Symbol, SymbolReference> outputsToInputs = new HashMap<Symbol, SymbolReference>();
                for (int index = 0; index < node.getInputs().get(i).size(); ++index) {
                    outputsToInputs.put(node.getOutputSymbols().get(index), node.getInputs().get(i).get(index).toSymbolReference());
                }
                Expression sourcePredicate = ExpressionSymbolInliner.inlineSymbols(outputsToInputs, context.get());
                PlanNode source = node.getSources().get(i);
                PlanNode rewrittenSource = context.rewrite(source, sourcePredicate);
                if (rewrittenSource != source) {
                    modified = true;
                }
                builder.add((Object)rewrittenSource);
            }
            if (modified) {
                return new ExchangeNode(node.getId(), node.getType(), node.getScope(), node.getPartitioningScheme(), (List<PlanNode>)builder.build(), node.getInputs(), node.getOrderingScheme());
            }
            return node;
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            List<Symbol> partitionSymbols = node.getPartitionBy();
            Predicate<Expression> isSupported = conjunct -> {
                if (!DeterminismEvaluator.isDeterministic(conjunct, this.metadata)) return false;
                if (!SymbolsExtractor.extractUnique(conjunct).stream().allMatch(partitionSymbols::contains)) return false;
                return true;
            };
            Map<Boolean, List<Expression>> conjuncts = ExpressionUtils.extractConjuncts(context.get()).stream().collect(Collectors.partitioningBy(isSupported));
            PlanNode rewrittenNode = context.defaultRewrite(node, ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)conjuncts.get(true)));
            if (!conjuncts.get(false).isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)conjuncts.get(false)));
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Set deterministicSymbols = node.getAssignments().entrySet().stream().filter(entry -> DeterminismEvaluator.isDeterministic((Expression)entry.getValue(), this.metadata)).map(Map.Entry::getKey).collect(Collectors.toSet());
            Predicate<Expression> deterministic = conjunct -> SymbolsExtractor.extractUnique(conjunct).stream().allMatch(deterministicSymbols::contains);
            Map<Boolean, List<Expression>> conjuncts = ExpressionUtils.extractConjuncts(context.get()).stream().collect(Collectors.partitioningBy(deterministic));
            List<Expression> deterministicConjuncts = conjuncts.get(true);
            Map<Boolean, List<Expression>> inlineConjuncts = deterministicConjuncts.stream().collect(Collectors.partitioningBy(expression -> this.isInliningCandidate((Expression)expression, node)));
            List<Expression> inlinedDeterministicConjuncts = inlineConjuncts.get(true).stream().map(entry -> ExpressionSymbolInliner.inlineSymbols(node.getAssignments().getMap(), entry)).map(conjunct -> CanonicalizeExpressionRewriter.canonicalizeExpression(conjunct, this.typeAnalyzer.getTypes(this.session, this.types, (Expression)conjunct), this.metadata)).map(conjunct -> UnwrapCastInComparison.unwrapCasts(this.session, this.metadata, this.typeOperators, this.typeAnalyzer, this.types, conjunct)).collect(Collectors.toList());
            PlanNode rewrittenNode = context.defaultRewrite(node, ExpressionUtils.combineConjuncts(this.metadata, inlinedDeterministicConjuncts));
            List<Expression> nonInliningConjuncts = inlineConjuncts.get(false);
            nonInliningConjuncts.addAll((Collection<Expression>)conjuncts.get(false));
            if (!nonInliningConjuncts.isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, ExpressionUtils.combineConjuncts(this.metadata, nonInliningConjuncts));
            }
            return rewrittenNode;
        }

        private boolean isInliningCandidate(Expression expression, ProjectNode node) {
            Verify.verify((boolean)AstUtils.preOrder((Node)expression).noneMatch(TryExpression.class::isInstance));
            ImmutableSet childOutputSet = ImmutableSet.copyOf(node.getOutputSymbols());
            Map dependencies = SymbolsExtractor.extractAll(expression).stream().filter(((Set)childOutputSet)::contains).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            return dependencies.entrySet().stream().allMatch(entry -> (Long)entry.getValue() == 1L || node.getAssignments().get((Symbol)entry.getKey()) instanceof Literal || node.getAssignments().get((Symbol)entry.getKey()) instanceof SymbolReference);
        }

        @Override
        public PlanNode visitGroupId(GroupIdNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Map commonGroupingSymbolMapping = (Map)node.getGroupingColumns().entrySet().stream().filter(entry -> node.getCommonGroupingColumns().contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Symbol)entry.getValue()).toSymbolReference()));
            Predicate<Expression> pushdownEligiblePredicate = conjunct -> commonGroupingSymbolMapping.keySet().containsAll(SymbolsExtractor.extractUnique(conjunct));
            Map<Boolean, List<Expression>> conjuncts = ExpressionUtils.extractConjuncts(context.get()).stream().collect(Collectors.partitioningBy(pushdownEligiblePredicate));
            PlanNode rewrittenNode = context.defaultRewrite(node, ExpressionSymbolInliner.inlineSymbols(commonGroupingSymbolMapping, ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)conjuncts.get(true))));
            if (!conjuncts.get(false).isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)conjuncts.get(false)));
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            ImmutableSet pushDownableSymbols = ImmutableSet.copyOf(node.getDistinctSymbols());
            Map<Boolean, List<Expression>> conjuncts = ExpressionUtils.extractConjuncts(context.get()).stream().collect(Collectors.partitioningBy(arg_0 -> Rewriter.lambda$visitMarkDistinct$11((Set)pushDownableSymbols, arg_0)));
            PlanNode rewrittenNode = context.defaultRewrite(node, ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)conjuncts.get(true)));
            if (!conjuncts.get(false).isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)conjuncts.get(false)));
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            boolean modified = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                Expression sourcePredicate = ExpressionSymbolInliner.inlineSymbols(node.sourceSymbolMap(i), context.get());
                PlanNode source = node.getSources().get(i);
                PlanNode rewrittenSource = context.rewrite(source, sourcePredicate);
                if (rewrittenSource != source) {
                    modified = true;
                }
                builder.add((Object)rewrittenSource);
            }
            if (modified) {
                return new UnionNode(node.getId(), (List<PlanNode>)builder.build(), node.getSymbolMapping(), node.getOutputSymbols());
            }
            return node;
        }

        @Override
        @Deprecated
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            PlanNode rewrittenPlan = context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(this.metadata, node.getPredicate(), context.get()));
            if (!(rewrittenPlan instanceof FilterNode)) {
                return rewrittenPlan;
            }
            FilterNode rewrittenFilterNode = (FilterNode)rewrittenPlan;
            if (!this.areExpressionsEquivalent(rewrittenFilterNode.getPredicate(), node.getPredicate()) || node.getSource() != rewrittenFilterNode.getSource()) {
                return rewrittenPlan;
            }
            return node;
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            PlanNode rightSource;
            PlanNode leftSource;
            Expression newJoinPredicate;
            Expression postJoinPredicate;
            BooleanLiteral rightPredicate;
            BooleanLiteral leftPredicate;
            Expression inheritedPredicate = context.get();
            node = this.tryNormalizeToOuterToInnerJoin(node, inheritedPredicate);
            Expression leftEffectivePredicate = this.effectivePredicateExtractor.extract(this.session, node.getLeft(), this.types, this.typeAnalyzer);
            Expression rightEffectivePredicate = this.effectivePredicateExtractor.extract(this.session, node.getRight(), this.types, this.typeAnalyzer);
            Expression joinPredicate = this.extractJoinPredicate(node);
            switch (node.getType()) {
                case INNER: {
                    InnerJoinPushDownResult innerJoinPushDownResult = this.processInnerJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputSymbols(), node.getRight().getOutputSymbols());
                    leftPredicate = innerJoinPushDownResult.getLeftPredicate();
                    rightPredicate = innerJoinPushDownResult.getRightPredicate();
                    postJoinPredicate = innerJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = innerJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case LEFT: {
                    OuterJoinPushDownResult leftOuterJoinPushDownResult = this.processLimitedOuterJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputSymbols(), node.getRight().getOutputSymbols());
                    leftPredicate = leftOuterJoinPushDownResult.getOuterJoinPredicate();
                    rightPredicate = leftOuterJoinPushDownResult.getInnerJoinPredicate();
                    postJoinPredicate = leftOuterJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = leftOuterJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case RIGHT: {
                    OuterJoinPushDownResult rightOuterJoinPushDownResult = this.processLimitedOuterJoin(inheritedPredicate, rightEffectivePredicate, leftEffectivePredicate, joinPredicate, node.getRight().getOutputSymbols(), node.getLeft().getOutputSymbols());
                    leftPredicate = rightOuterJoinPushDownResult.getInnerJoinPredicate();
                    rightPredicate = rightOuterJoinPushDownResult.getOuterJoinPredicate();
                    postJoinPredicate = rightOuterJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = rightOuterJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case FULL: {
                    leftPredicate = BooleanLiteral.TRUE_LITERAL;
                    rightPredicate = BooleanLiteral.TRUE_LITERAL;
                    postJoinPredicate = inheritedPredicate;
                    newJoinPredicate = joinPredicate;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported join type: " + node.getType());
                }
            }
            newJoinPredicate = this.simplifyExpression(newJoinPredicate);
            Assignments.Builder leftProjections = Assignments.builder();
            leftProjections.putAll((Map)node.getLeft().getOutputSymbols().stream().collect(ImmutableMap.toImmutableMap(key -> key, Symbol::toSymbolReference)));
            Assignments.Builder rightProjections = Assignments.builder();
            rightProjections.putAll((Map)node.getRight().getOutputSymbols().stream().collect(ImmutableMap.toImmutableMap(key -> key, Symbol::toSymbolReference)));
            ArrayList<JoinNode.EquiJoinClause> equiJoinClauses = new ArrayList<JoinNode.EquiJoinClause>();
            ImmutableList.Builder joinFilterBuilder = ImmutableList.builder();
            for (Expression conjunct : ExpressionUtils.extractConjuncts(newJoinPredicate)) {
                if (this.joinEqualityExpression(conjunct, node.getLeft().getOutputSymbols(), node.getRight().getOutputSymbols())) {
                    ComparisonExpression equality = (ComparisonExpression)conjunct;
                    boolean alignedComparison = node.getLeft().getOutputSymbols().containsAll(SymbolsExtractor.extractUnique(equality.getLeft()));
                    Expression leftExpression = alignedComparison ? equality.getLeft() : equality.getRight();
                    Expression rightExpression = alignedComparison ? equality.getRight() : equality.getLeft();
                    Symbol leftSymbol = this.symbolForExpression(leftExpression);
                    if (!node.getLeft().getOutputSymbols().contains(leftSymbol)) {
                        leftProjections.put(leftSymbol, leftExpression);
                    }
                    Symbol rightSymbol = this.symbolForExpression(rightExpression);
                    if (!node.getRight().getOutputSymbols().contains(rightSymbol)) {
                        rightProjections.put(rightSymbol, rightExpression);
                    }
                    equiJoinClauses.add(new JoinNode.EquiJoinClause(leftSymbol, rightSymbol));
                    continue;
                }
                joinFilterBuilder.add((Object)conjunct);
            }
            ImmutableList joinFilter = joinFilterBuilder.build();
            DynamicFiltersResult dynamicFiltersResult = this.createDynamicFilters(node, equiJoinClauses, (List<Expression>)joinFilter, this.session, this.idAllocator);
            Map<DynamicFilterId, Symbol> dynamicFilters = dynamicFiltersResult.getDynamicFilters();
            leftPredicate = ExpressionUtils.combineConjuncts(this.metadata, new Expression[]{leftPredicate, ExpressionUtils.combineConjuncts(this.metadata, dynamicFiltersResult.getPredicates())});
            boolean equiJoinClausesUnmodified = ImmutableSet.copyOf(equiJoinClauses).equals((Object)ImmutableSet.copyOf(node.getCriteria()));
            if (!equiJoinClausesUnmodified) {
                leftSource = context.rewrite(new ProjectNode(this.idAllocator.getNextId(), node.getLeft(), leftProjections.build()), (Expression)leftPredicate);
                rightSource = context.rewrite(new ProjectNode(this.idAllocator.getNextId(), node.getRight(), rightProjections.build()), (Expression)rightPredicate);
            } else {
                leftSource = context.rewrite(node.getLeft(), (Expression)leftPredicate);
                rightSource = context.rewrite(node.getRight(), (Expression)rightPredicate);
            }
            Optional<Object> newJoinFilter = Optional.of(ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)joinFilter));
            if (newJoinFilter.get() == BooleanLiteral.TRUE_LITERAL) {
                newJoinFilter = Optional.empty();
            }
            if (node.getType() == JoinNode.Type.INNER && newJoinFilter.isPresent() && equiJoinClauses.isEmpty()) {
                postJoinPredicate = ExpressionUtils.combineConjuncts(this.metadata, postJoinPredicate, (Expression)newJoinFilter.get());
                newJoinFilter = Optional.empty();
            }
            boolean filtersEquivalent = newJoinFilter.isPresent() == node.getFilter().isPresent() && (newJoinFilter.isEmpty() || this.areExpressionsEquivalent((Expression)newJoinFilter.get(), node.getFilter().get()));
            PlanNode output = node;
            if (!(leftSource == node.getLeft() && rightSource == node.getRight() && filtersEquivalent && dynamicFilters.equals(node.getDynamicFilters()) && equiJoinClausesUnmodified)) {
                leftSource = new ProjectNode(this.idAllocator.getNextId(), leftSource, leftProjections.build());
                rightSource = new ProjectNode(this.idAllocator.getNextId(), rightSource, rightProjections.build());
                output = new JoinNode(node.getId(), node.getType(), leftSource, rightSource, equiJoinClauses, leftSource.getOutputSymbols(), rightSource.getOutputSymbols(), newJoinFilter, node.getLeftHashSymbol(), node.getRightHashSymbol(), node.getDistributionType(), node.isSpillable(), dynamicFilters, node.getReorderJoinStatsAndCost());
            }
            if (!postJoinPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                output = new FilterNode(this.idAllocator.getNextId(), output, postJoinPredicate);
            }
            if (!node.getOutputSymbols().equals(((PlanNode)output).getOutputSymbols())) {
                output = new ProjectNode(this.idAllocator.getNextId(), output, Assignments.identity(node.getOutputSymbols()));
            }
            return output;
        }

        private DynamicFiltersResult createDynamicFilters(JoinNode node, List<JoinNode.EquiJoinClause> equiJoinClauses, List<Expression> joinFilterClauses, Session session, PlanNodeIdAllocator idAllocator) {
            if (node.getType() != JoinNode.Type.INNER && node.getType() != JoinNode.Type.RIGHT || !SystemSessionProperties.isEnableDynamicFiltering(session) || !this.dynamicFiltering) {
                return new DynamicFiltersResult((Map<DynamicFilterId, Symbol>)ImmutableMap.of(), (List<Expression>)ImmutableList.of());
            }
            List clauses = (List)Streams.concat((Stream[])new Stream[]{equiJoinClauses.stream().map(clause -> new DynamicFilterExpression(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)clause.getLeft().toSymbolReference(), (Expression)clause.getRight().toSymbolReference()))), joinFilterClauses.stream().flatMap(Rewriter::tryConvertBetweenIntoComparisons).filter(clause -> this.joinDynamicFilteringExpression((Expression)clause, (Collection<Symbol>)node.getLeft().getOutputSymbols(), (Collection<Symbol>)node.getRight().getOutputSymbols())).map(expression -> {
                if (expression instanceof NotExpression) {
                    NotExpression notExpression = (NotExpression)expression;
                    ComparisonExpression comparison = (ComparisonExpression)notExpression.getValue();
                    return new DynamicFilterExpression(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, comparison.getLeft(), comparison.getRight()), true);
                }
                return new DynamicFilterExpression((ComparisonExpression)expression);
            }).map(expression -> {
                ComparisonExpression comparison = expression.getComparison();
                Symbol leftSymbol = Symbol.from(comparison.getLeft());
                Symbol rightSymbol = Symbol.from(comparison.getRight());
                boolean alignedComparison = node.getLeft().getOutputSymbols().contains(leftSymbol);
                return new DynamicFilterExpression(new ComparisonExpression(alignedComparison ? comparison.getOperator() : comparison.getOperator().flip(), (Expression)(alignedComparison ? leftSymbol : rightSymbol).toSymbolReference(), (Expression)(alignedComparison ? rightSymbol : leftSymbol).toSymbolReference()), expression.isNullAllowed());
            })}).collect(ImmutableList.toImmutableList());
            Set buildSymbols = (Set)clauses.stream().map(DynamicFilterExpression::getComparison).map(ComparisonExpression::getRight).map(Symbol::from).collect(ImmutableSet.toImmutableSet());
            BiMap buildSymbolToDynamicFilter = HashBiMap.create(node.getDynamicFilters()).inverse();
            for (Symbol buildSymbol : buildSymbols) {
                buildSymbolToDynamicFilter.computeIfAbsent((Object)buildSymbol, key -> new DynamicFilterId("df_" + idAllocator.getNextId().toString()));
            }
            List predicates = (List)clauses.stream().map(clause -> {
                ComparisonExpression comparison = clause.getComparison();
                Symbol probeSymbol = Symbol.from(comparison.getLeft());
                Symbol buildSymbol = Symbol.from(comparison.getRight());
                Type type = this.symbolAllocator.getTypes().get(probeSymbol);
                DynamicFilterId id = Objects.requireNonNull((DynamicFilterId)buildSymbolToDynamicFilter.get((Object)buildSymbol), () -> "missing dynamic filter for symbol " + buildSymbol);
                return DynamicFilters.createDynamicFilterExpression(this.metadata, id, type, probeSymbol.toSymbolReference(), comparison.getOperator(), clause.isNullAllowed());
            }).collect(ImmutableList.toImmutableList());
            return new DynamicFiltersResult((Map<DynamicFilterId, Symbol>)buildSymbolToDynamicFilter.inverse(), predicates);
        }

        private static Stream<Expression> tryConvertBetweenIntoComparisons(Expression clause) {
            if (clause instanceof BetweenPredicate) {
                BetweenPredicate between = (BetweenPredicate)clause;
                return Stream.of(new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, between.getValue(), between.getMin()), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, between.getValue(), between.getMax()));
            }
            return Stream.of(clause);
        }

        @Override
        public PlanNode visitSpatialJoin(SpatialJoinNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression newJoinPredicate;
            Expression postJoinPredicate;
            Expression rightPredicate;
            Expression leftPredicate;
            Expression inheritedPredicate = context.get();
            if (node.getType() == SpatialJoinNode.Type.LEFT && this.canConvertOuterToInner(node.getRight().getOutputSymbols(), inheritedPredicate)) {
                node = new SpatialJoinNode(node.getId(), SpatialJoinNode.Type.INNER, node.getLeft(), node.getRight(), node.getOutputSymbols(), node.getFilter(), node.getLeftPartitionSymbol(), node.getRightPartitionSymbol(), node.getKdbTree());
            }
            Expression leftEffectivePredicate = this.effectivePredicateExtractor.extract(this.session, node.getLeft(), this.types, this.typeAnalyzer);
            Expression rightEffectivePredicate = this.effectivePredicateExtractor.extract(this.session, node.getRight(), this.types, this.typeAnalyzer);
            Expression joinPredicate = node.getFilter();
            switch (node.getType()) {
                case INNER: {
                    InnerJoinPushDownResult innerJoinPushDownResult = this.processInnerJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputSymbols(), node.getRight().getOutputSymbols());
                    leftPredicate = innerJoinPushDownResult.getLeftPredicate();
                    rightPredicate = innerJoinPushDownResult.getRightPredicate();
                    postJoinPredicate = innerJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = innerJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case LEFT: {
                    OuterJoinPushDownResult leftOuterJoinPushDownResult = this.processLimitedOuterJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputSymbols(), node.getRight().getOutputSymbols());
                    leftPredicate = leftOuterJoinPushDownResult.getOuterJoinPredicate();
                    rightPredicate = leftOuterJoinPushDownResult.getInnerJoinPredicate();
                    postJoinPredicate = leftOuterJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = leftOuterJoinPushDownResult.getJoinPredicate();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported spatial join type: " + node.getType());
                }
            }
            newJoinPredicate = this.simplifyExpression(newJoinPredicate);
            Verify.verify((!newJoinPredicate.equals((Object)BooleanLiteral.FALSE_LITERAL) ? 1 : 0) != 0, (String)"Spatial join predicate is missing", (Object[])new Object[0]);
            PlanNode leftSource = context.rewrite(node.getLeft(), leftPredicate);
            PlanNode rightSource = context.rewrite(node.getRight(), rightPredicate);
            PlanNode output = node;
            if (leftSource != node.getLeft() || rightSource != node.getRight() || !this.areExpressionsEquivalent(newJoinPredicate, joinPredicate)) {
                Assignments.Builder leftProjections = Assignments.builder();
                leftProjections.putAll((Map)node.getLeft().getOutputSymbols().stream().collect(ImmutableMap.toImmutableMap(key -> key, Symbol::toSymbolReference)));
                Assignments.Builder rightProjections = Assignments.builder();
                rightProjections.putAll((Map)node.getRight().getOutputSymbols().stream().collect(ImmutableMap.toImmutableMap(key -> key, Symbol::toSymbolReference)));
                leftSource = new ProjectNode(this.idAllocator.getNextId(), leftSource, leftProjections.build());
                rightSource = new ProjectNode(this.idAllocator.getNextId(), rightSource, rightProjections.build());
                output = new SpatialJoinNode(node.getId(), node.getType(), leftSource, rightSource, node.getOutputSymbols(), newJoinPredicate, node.getLeftPartitionSymbol(), node.getRightPartitionSymbol(), node.getKdbTree());
            }
            if (!postJoinPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                output = new FilterNode(this.idAllocator.getNextId(), output, postJoinPredicate);
            }
            return output;
        }

        private Symbol symbolForExpression(Expression expression) {
            if (expression instanceof SymbolReference) {
                return Symbol.from(expression);
            }
            return this.symbolAllocator.newSymbol(expression, this.typeAnalyzer.getType(this.session, this.symbolAllocator.getTypes(), expression));
        }

        private OuterJoinPushDownResult processLimitedOuterJoin(Expression inheritedPredicate, Expression outerEffectivePredicate, Expression innerEffectivePredicate, Expression joinPredicate, Collection<Symbol> outerSymbols, Collection<Symbol> innerSymbols) {
            Preconditions.checkArgument((boolean)outerSymbols.containsAll(SymbolsExtractor.extractUnique(outerEffectivePredicate)), (Object)"outerEffectivePredicate must only contain symbols from outerSymbols");
            Preconditions.checkArgument((boolean)innerSymbols.containsAll(SymbolsExtractor.extractUnique(innerEffectivePredicate)), (Object)"innerEffectivePredicate must only contain symbols from innerSymbols");
            ImmutableList.Builder outerPushdownConjuncts = ImmutableList.builder();
            ImmutableList.Builder innerPushdownConjuncts = ImmutableList.builder();
            ImmutableList.Builder postJoinConjuncts = ImmutableList.builder();
            ImmutableList.Builder joinConjuncts = ImmutableList.builder();
            ExpressionUtils.extractConjuncts(inheritedPredicate).stream().filter(expression -> !DeterminismEvaluator.isDeterministic(expression, this.metadata)).forEach(arg_0 -> ((ImmutableList.Builder)postJoinConjuncts).add(arg_0));
            inheritedPredicate = ExpressionUtils.filterDeterministicConjuncts(this.metadata, inheritedPredicate);
            outerEffectivePredicate = ExpressionUtils.filterDeterministicConjuncts(this.metadata, outerEffectivePredicate);
            innerEffectivePredicate = ExpressionUtils.filterDeterministicConjuncts(this.metadata, innerEffectivePredicate);
            ExpressionUtils.extractConjuncts(joinPredicate).stream().filter(expression -> !DeterminismEvaluator.isDeterministic(expression, this.metadata)).forEach(arg_0 -> ((ImmutableList.Builder)joinConjuncts).add(arg_0));
            joinPredicate = ExpressionUtils.filterDeterministicConjuncts(this.metadata, joinPredicate);
            EqualityInference inheritedInference = EqualityInference.newInstance(this.metadata, inheritedPredicate);
            EqualityInference outerInference = EqualityInference.newInstance(this.metadata, inheritedPredicate, outerEffectivePredicate);
            ImmutableSet innerScope = ImmutableSet.copyOf(innerSymbols);
            ImmutableSet outerScope = ImmutableSet.copyOf(outerSymbols);
            EqualityInference.EqualityPartition equalityPartition = inheritedInference.generateEqualitiesPartitionedBy((Set<Symbol>)outerScope);
            Expression outerOnlyInheritedEqualities = ExpressionUtils.combineConjuncts(this.metadata, equalityPartition.getScopeEqualities());
            EqualityInference potentialNullSymbolInference = EqualityInference.newInstance(this.metadata, outerOnlyInheritedEqualities, outerEffectivePredicate, innerEffectivePredicate, joinPredicate);
            EqualityInference potentialNullSymbolInferenceWithoutInnerInferred = EqualityInference.newInstance(this.metadata, outerOnlyInheritedEqualities, outerEffectivePredicate, joinPredicate);
            innerPushdownConjuncts.addAll(potentialNullSymbolInferenceWithoutInnerInferred.generateEqualitiesPartitionedBy((Set<Symbol>)innerScope).getScopeEqualities());
            EqualityInference.EqualityPartition joinEqualityPartition = EqualityInference.newInstance(this.metadata, joinPredicate).generateEqualitiesPartitionedBy((Set<Symbol>)innerScope);
            innerPushdownConjuncts.addAll(joinEqualityPartition.getScopeEqualities());
            joinConjuncts.addAll(joinEqualityPartition.getScopeComplementEqualities()).addAll(joinEqualityPartition.getScopeStraddlingEqualities());
            outerPushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(this.metadata, inheritedPredicate)) {
                Expression outerRewritten = outerInference.rewrite(conjunct, (Set<Symbol>)outerScope);
                if (outerRewritten != null) {
                    outerPushdownConjuncts.add((Object)outerRewritten);
                    Expression innerRewritten = potentialNullSymbolInference.rewrite(outerRewritten, (Set<Symbol>)innerScope);
                    if (innerRewritten == null) continue;
                    innerPushdownConjuncts.add((Object)innerRewritten);
                    continue;
                }
                postJoinConjuncts.add((Object)conjunct);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(this.metadata, outerEffectivePredicate)) {
                Expression rewritten = potentialNullSymbolInference.rewrite(conjunct, (Set<Symbol>)innerScope);
                if (rewritten == null) continue;
                innerPushdownConjuncts.add((Object)rewritten);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(this.metadata, joinPredicate)) {
                Expression innerRewritten = potentialNullSymbolInference.rewrite(conjunct, (Set<Symbol>)innerScope);
                if (innerRewritten != null) {
                    innerPushdownConjuncts.add((Object)innerRewritten);
                    continue;
                }
                joinConjuncts.add((Object)conjunct);
            }
            return new OuterJoinPushDownResult(ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)outerPushdownConjuncts.build()), ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)innerPushdownConjuncts.build()), ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)joinConjuncts.build()), ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)postJoinConjuncts.build()));
        }

        private InnerJoinPushDownResult processInnerJoin(Expression inheritedPredicate, Expression leftEffectivePredicate, Expression rightEffectivePredicate, Expression joinPredicate, Collection<Symbol> leftSymbols, Collection<Symbol> rightSymbols) {
            Expression rewritten;
            Preconditions.checkArgument((boolean)leftSymbols.containsAll(SymbolsExtractor.extractUnique(leftEffectivePredicate)), (Object)"leftEffectivePredicate must only contain symbols from leftSymbols");
            Preconditions.checkArgument((boolean)rightSymbols.containsAll(SymbolsExtractor.extractUnique(rightEffectivePredicate)), (Object)"rightEffectivePredicate must only contain symbols from rightSymbols");
            ImmutableList.Builder leftPushDownConjuncts = ImmutableList.builder();
            ImmutableList.Builder rightPushDownConjuncts = ImmutableList.builder();
            ImmutableList.Builder joinConjuncts = ImmutableList.builder();
            ExpressionUtils.extractConjuncts(inheritedPredicate).stream().filter(deterministic -> !DeterminismEvaluator.isDeterministic(deterministic, this.metadata)).forEach(arg_0 -> ((ImmutableList.Builder)joinConjuncts).add(arg_0));
            inheritedPredicate = ExpressionUtils.filterDeterministicConjuncts(this.metadata, inheritedPredicate);
            ExpressionUtils.extractConjuncts(joinPredicate).stream().filter(expression -> !DeterminismEvaluator.isDeterministic(expression, this.metadata)).forEach(arg_0 -> ((ImmutableList.Builder)joinConjuncts).add(arg_0));
            joinPredicate = ExpressionUtils.filterDeterministicConjuncts(this.metadata, joinPredicate);
            leftEffectivePredicate = ExpressionUtils.filterDeterministicConjuncts(this.metadata, leftEffectivePredicate);
            rightEffectivePredicate = ExpressionUtils.filterDeterministicConjuncts(this.metadata, rightEffectivePredicate);
            ImmutableSet leftScope = ImmutableSet.copyOf(leftSymbols);
            ImmutableSet rightScope = ImmutableSet.copyOf(rightSymbols);
            EqualityInference predicateInference = EqualityInference.newInstance(this.metadata, inheritedPredicate);
            Expression simplifiedLeftEffectivePredicate = predicateInference.rewrite(leftEffectivePredicate, (Set<Symbol>)leftScope);
            Expression simplifiedRightEffectivePredicate = predicateInference.rewrite(rightEffectivePredicate, (Set<Symbol>)rightScope);
            EqualityInference assertions = EqualityInference.newInstance(this.metadata, leftEffectivePredicate, rightEffectivePredicate);
            inheritedPredicate = assertions.rewrite(inheritedPredicate, (Set<Symbol>)Sets.union((Set)leftScope, (Set)rightScope));
            EqualityInference allInference = EqualityInference.newInstance(this.metadata, inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, simplifiedLeftEffectivePredicate, simplifiedRightEffectivePredicate);
            EqualityInference allInferenceWithoutLeftInferred = EqualityInference.newInstance(this.metadata, inheritedPredicate, rightEffectivePredicate, joinPredicate, simplifiedRightEffectivePredicate);
            EqualityInference allInferenceWithoutRightInferred = EqualityInference.newInstance(this.metadata, inheritedPredicate, leftEffectivePredicate, joinPredicate, simplifiedLeftEffectivePredicate);
            leftPushDownConjuncts.addAll(allInferenceWithoutLeftInferred.generateEqualitiesPartitionedBy((Set<Symbol>)leftScope).getScopeEqualities());
            rightPushDownConjuncts.addAll(allInferenceWithoutRightInferred.generateEqualitiesPartitionedBy((Set<Symbol>)rightScope).getScopeEqualities());
            joinConjuncts.addAll(allInference.generateEqualitiesPartitionedBy((Set<Symbol>)leftScope).getScopeStraddlingEqualities());
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(this.metadata, inheritedPredicate)) {
                Expression rightRewrittenConjunct;
                Expression leftRewrittenConjunct = allInference.rewrite(conjunct, (Set<Symbol>)leftScope);
                if (leftRewrittenConjunct != null) {
                    leftPushDownConjuncts.add((Object)leftRewrittenConjunct);
                }
                if ((rightRewrittenConjunct = allInference.rewrite(conjunct, (Set<Symbol>)rightScope)) != null) {
                    rightPushDownConjuncts.add((Object)rightRewrittenConjunct);
                }
                if (leftRewrittenConjunct != null || rightRewrittenConjunct != null) continue;
                joinConjuncts.add((Object)conjunct);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(this.metadata, simplifiedRightEffectivePredicate)) {
                rewritten = allInference.rewrite(conjunct, (Set<Symbol>)leftScope);
                if (rewritten == null) continue;
                leftPushDownConjuncts.add((Object)rewritten);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(this.metadata, simplifiedLeftEffectivePredicate)) {
                rewritten = allInference.rewrite(conjunct, (Set<Symbol>)rightScope);
                if (rewritten == null) continue;
                rightPushDownConjuncts.add((Object)rewritten);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(this.metadata, joinPredicate)) {
                Expression rightRewritten;
                Expression leftRewritten = allInference.rewrite(conjunct, (Set<Symbol>)leftScope);
                if (leftRewritten != null) {
                    leftPushDownConjuncts.add((Object)leftRewritten);
                }
                if ((rightRewritten = allInference.rewrite(conjunct, (Set<Symbol>)rightScope)) != null) {
                    rightPushDownConjuncts.add((Object)rightRewritten);
                }
                if (leftRewritten != null || rightRewritten != null) continue;
                joinConjuncts.add((Object)conjunct);
            }
            return new InnerJoinPushDownResult(ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)leftPushDownConjuncts.build()), ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)rightPushDownConjuncts.build()), ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)joinConjuncts.build()), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        private Expression extractJoinPredicate(JoinNode joinNode) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JoinNode.EquiJoinClause equiJoinClause : joinNode.getCriteria()) {
                builder.add((Object)equiJoinClause.toExpression());
            }
            joinNode.getFilter().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            return ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)builder.build());
        }

        private JoinNode tryNormalizeToOuterToInnerJoin(JoinNode node, Expression inheritedPredicate) {
            Preconditions.checkArgument((boolean)EnumSet.of(JoinNode.Type.INNER, JoinNode.Type.RIGHT, JoinNode.Type.LEFT, JoinNode.Type.FULL).contains((Object)node.getType()), (String)"Unsupported join type: %s", (Object)((Object)node.getType()));
            if (node.getType() == JoinNode.Type.INNER) {
                return node;
            }
            if (node.getType() == JoinNode.Type.FULL) {
                boolean canConvertToLeftJoin = this.canConvertOuterToInner(node.getLeft().getOutputSymbols(), inheritedPredicate);
                boolean canConvertToRightJoin = this.canConvertOuterToInner(node.getRight().getOutputSymbols(), inheritedPredicate);
                if (!canConvertToLeftJoin && !canConvertToRightJoin) {
                    return node;
                }
                if (canConvertToLeftJoin && canConvertToRightJoin) {
                    return new JoinNode(node.getId(), JoinNode.Type.INNER, node.getLeft(), node.getRight(), node.getCriteria(), node.getLeftOutputSymbols(), node.getRightOutputSymbols(), node.getFilter(), node.getLeftHashSymbol(), node.getRightHashSymbol(), node.getDistributionType(), node.isSpillable(), node.getDynamicFilters(), node.getReorderJoinStatsAndCost());
                }
                return new JoinNode(node.getId(), canConvertToLeftJoin ? JoinNode.Type.LEFT : JoinNode.Type.RIGHT, node.getLeft(), node.getRight(), node.getCriteria(), node.getLeftOutputSymbols(), node.getRightOutputSymbols(), node.getFilter(), node.getLeftHashSymbol(), node.getRightHashSymbol(), node.getDistributionType(), node.isSpillable(), node.getDynamicFilters(), node.getReorderJoinStatsAndCost());
            }
            if (node.getType() == JoinNode.Type.LEFT && !this.canConvertOuterToInner(node.getRight().getOutputSymbols(), inheritedPredicate) || node.getType() == JoinNode.Type.RIGHT && !this.canConvertOuterToInner(node.getLeft().getOutputSymbols(), inheritedPredicate)) {
                return node;
            }
            return new JoinNode(node.getId(), JoinNode.Type.INNER, node.getLeft(), node.getRight(), node.getCriteria(), node.getLeftOutputSymbols(), node.getRightOutputSymbols(), node.getFilter(), node.getLeftHashSymbol(), node.getRightHashSymbol(), node.getDistributionType(), node.isSpillable(), node.getDynamicFilters(), node.getReorderJoinStatsAndCost());
        }

        private boolean canConvertOuterToInner(List<Symbol> innerSymbolsForOuterJoin, Expression inheritedPredicate) {
            ImmutableSet innerSymbols = ImmutableSet.copyOf(innerSymbolsForOuterJoin);
            for (Expression conjunct : ExpressionUtils.extractConjuncts(inheritedPredicate)) {
                Object response;
                if (!DeterminismEvaluator.isDeterministic(conjunct, this.metadata) || (response = this.nullInputEvaluator((Collection<Symbol>)innerSymbols, conjunct)) != null && !(response instanceof NullLiteral) && !Boolean.FALSE.equals(response)) continue;
                return true;
            }
            return false;
        }

        private Expression simplifyExpression(Expression expression) {
            Map<NodeRef<Expression>, Type> expressionTypes = this.typeAnalyzer.getTypes(this.session, this.symbolAllocator.getTypes(), expression);
            ExpressionInterpreter optimizer = ExpressionInterpreter.expressionOptimizer(expression, this.metadata, this.session, expressionTypes);
            return this.literalEncoder.toExpression(optimizer.optimize(NoOpSymbolResolver.INSTANCE), expressionTypes.get(NodeRef.of((Node)expression)));
        }

        private boolean areExpressionsEquivalent(Expression leftExpression, Expression rightExpression) {
            return this.expressionEquivalence.areExpressionsEquivalent(this.session, leftExpression, rightExpression, this.types);
        }

        private Object nullInputEvaluator(Collection<Symbol> nullSymbols, Expression expression) {
            Map<NodeRef<Expression>, Type> expressionTypes = this.typeAnalyzer.getTypes(this.session, this.symbolAllocator.getTypes(), expression);
            return ExpressionInterpreter.expressionOptimizer(expression, this.metadata, this.session, expressionTypes).optimize(symbol -> nullSymbols.contains(symbol) ? null : symbol.toSymbolReference());
        }

        private boolean joinEqualityExpression(Expression expression, Collection<Symbol> leftSymbols, Collection<Symbol> rightSymbols) {
            return this.joinComparisonExpression(expression, leftSymbols, rightSymbols, (Set<ComparisonExpression.Operator>)ImmutableSet.of((Object)ComparisonExpression.Operator.EQUAL));
        }

        private boolean joinDynamicFilteringExpression(Expression expression, Collection<Symbol> leftSymbols, Collection<Symbol> rightSymbols) {
            ComparisonExpression comparison;
            if (expression instanceof NotExpression) {
                NotExpression notExpression = (NotExpression)expression;
                boolean isDistinctFrom = this.joinComparisonExpression(notExpression.getValue(), leftSymbols, rightSymbols, (Set<ComparisonExpression.Operator>)ImmutableSet.of((Object)ComparisonExpression.Operator.IS_DISTINCT_FROM));
                if (!isDistinctFrom) {
                    return false;
                }
                comparison = (ComparisonExpression)notExpression.getValue();
                ImmutableSet expressionTypes = ImmutableSet.of((Object)this.typeAnalyzer.getType(this.session, this.types, comparison.getLeft()), (Object)this.typeAnalyzer.getType(this.session, this.types, comparison.getRight()));
                if (expressionTypes.contains(RealType.REAL) || expressionTypes.contains(DoubleType.DOUBLE)) {
                    return false;
                }
            } else {
                if (!this.joinComparisonExpression(expression, leftSymbols, rightSymbols, DYNAMIC_FILTERING_SUPPORTED_COMPARISONS)) {
                    return false;
                }
                comparison = (ComparisonExpression)expression;
            }
            return comparison.getLeft() instanceof SymbolReference && comparison.getRight() instanceof SymbolReference;
        }

        private boolean joinComparisonExpression(Expression expression, Collection<Symbol> leftSymbols, Collection<Symbol> rightSymbols, Set<ComparisonExpression.Operator> operators) {
            ComparisonExpression comparison;
            if (expression instanceof ComparisonExpression && DeterminismEvaluator.isDeterministic(expression, this.metadata) && operators.contains((comparison = (ComparisonExpression)expression).getOperator())) {
                Set<Symbol> symbols1 = SymbolsExtractor.extractUnique(comparison.getLeft());
                Set<Symbol> symbols2 = SymbolsExtractor.extractUnique(comparison.getRight());
                if (symbols1.isEmpty() || symbols2.isEmpty()) {
                    return false;
                }
                return leftSymbols.containsAll(symbols1) && rightSymbols.containsAll(symbols2) || rightSymbols.containsAll(symbols1) && leftSymbols.containsAll(symbols2);
            }
            return false;
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression inheritedPredicate = context.get();
            if (!ExpressionUtils.extractConjuncts(inheritedPredicate).contains(node.getSemiJoinOutput().toSymbolReference())) {
                return this.visitNonFilteringSemiJoin(node, context);
            }
            return this.visitFilteringSemiJoin(node, context);
        }

        private PlanNode visitNonFilteringSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression inheritedPredicate = context.get();
            ArrayList<Expression> sourceConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postJoinConjuncts = new ArrayList<Expression>();
            PlanNode rewrittenFilteringSource = context.defaultRewrite(node.getFilteringSource(), (Expression)BooleanLiteral.TRUE_LITERAL);
            ImmutableSet sourceScope = ImmutableSet.copyOf(node.getSource().getOutputSymbols());
            EqualityInference inheritedInference = EqualityInference.newInstance(this.metadata, inheritedPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(this.metadata, inheritedPredicate)) {
                Expression rewrittenConjunct = inheritedInference.rewrite(conjunct, (Set<Symbol>)sourceScope);
                if (rewrittenConjunct != null) {
                    sourceConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postJoinConjuncts.add(conjunct);
            }
            EqualityInference.EqualityPartition equalityPartition = inheritedInference.generateEqualitiesPartitionedBy((Set<Symbol>)sourceScope);
            sourceConjuncts.addAll(equalityPartition.getScopeEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(this.metadata, sourceConjuncts));
            PlanNode output = node;
            if (rewrittenSource != node.getSource() || rewrittenFilteringSource != node.getFilteringSource()) {
                output = new SemiJoinNode(node.getId(), rewrittenSource, rewrittenFilteringSource, node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput(), node.getSourceHashSymbol(), node.getFilteringSourceHashSymbol(), node.getDistributionType(), Optional.empty());
            }
            if (!postJoinConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), output, ExpressionUtils.combineConjuncts(this.metadata, postJoinConjuncts));
            }
            return output;
        }

        /*
         * WARNING - void declaration
         */
        private PlanNode visitFilteringSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            void var18_24;
            Expression rewritten;
            Expression inheritedPredicate = context.get();
            Expression deterministicInheritedPredicate = ExpressionUtils.filterDeterministicConjuncts(this.metadata, inheritedPredicate);
            Expression sourceEffectivePredicate = ExpressionUtils.filterDeterministicConjuncts(this.metadata, this.effectivePredicateExtractor.extract(this.session, node.getSource(), this.types, this.typeAnalyzer));
            Expression filteringSourceEffectivePredicate = ExpressionUtils.filterDeterministicConjuncts(this.metadata, this.effectivePredicateExtractor.extract(this.session, node.getFilteringSource(), this.types, this.typeAnalyzer));
            ComparisonExpression joinExpression = new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)node.getSourceJoinSymbol().toSymbolReference(), (Expression)node.getFilteringSourceJoinSymbol().toSymbolReference());
            List<Symbol> sourceSymbols = node.getSource().getOutputSymbols();
            List<Symbol> filteringSourceSymbols = node.getFilteringSource().getOutputSymbols();
            ArrayList<Expression> sourceConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> filteringSourceConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postJoinConjuncts = new ArrayList<Expression>();
            EqualityInference allInference = EqualityInference.newInstance(this.metadata, new Expression[]{deterministicInheritedPredicate, sourceEffectivePredicate, filteringSourceEffectivePredicate, joinExpression});
            EqualityInference allInferenceWithoutSourceInferred = EqualityInference.newInstance(this.metadata, new Expression[]{deterministicInheritedPredicate, filteringSourceEffectivePredicate, joinExpression});
            EqualityInference allInferenceWithoutFilteringSourceInferred = EqualityInference.newInstance(this.metadata, new Expression[]{deterministicInheritedPredicate, sourceEffectivePredicate, joinExpression});
            ImmutableSet sourceScope = ImmutableSet.copyOf(sourceSymbols);
            for (Expression expression : EqualityInference.nonInferrableConjuncts(this.metadata, inheritedPredicate)) {
                Expression rewrittenConjunct = allInference.rewrite(expression, (Set<Symbol>)sourceScope);
                if (rewrittenConjunct != null) {
                    sourceConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postJoinConjuncts.add(expression);
            }
            ImmutableSet filterScope = ImmutableSet.copyOf(filteringSourceSymbols);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(this.metadata, deterministicInheritedPredicate)) {
                Expression rewrittenConjunct = allInference.rewrite(conjunct, (Set<Symbol>)filterScope);
                if (rewrittenConjunct == null) continue;
                filteringSourceConjuncts.add(rewrittenConjunct);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(this.metadata, filteringSourceEffectivePredicate)) {
                rewritten = allInference.rewrite(conjunct, (Set<Symbol>)sourceScope);
                if (rewritten == null) continue;
                sourceConjuncts.add(rewritten);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(this.metadata, sourceEffectivePredicate)) {
                rewritten = allInference.rewrite(conjunct, (Set<Symbol>)filterScope);
                if (rewritten == null) continue;
                filteringSourceConjuncts.add(rewritten);
            }
            sourceConjuncts.addAll(allInferenceWithoutSourceInferred.generateEqualitiesPartitionedBy((Set<Symbol>)sourceScope).getScopeEqualities());
            filteringSourceConjuncts.addAll(allInferenceWithoutFilteringSourceInferred.generateEqualitiesPartitionedBy((Set<Symbol>)filterScope).getScopeEqualities());
            Optional<DynamicFilterId> optional = node.getDynamicFilterId();
            if (optional.isEmpty() && SystemSessionProperties.isEnableDynamicFiltering(this.session) && this.dynamicFiltering) {
                Optional<DynamicFilterId> optional2 = Optional.of(new DynamicFilterId("df_" + this.idAllocator.getNextId().toString()));
                Symbol sourceSymbol = node.getSourceJoinSymbol();
                sourceConjuncts.add(DynamicFilters.createDynamicFilterExpression(this.metadata, optional2.get(), this.symbolAllocator.getTypes().get(sourceSymbol), (Expression)sourceSymbol.toSymbolReference(), ComparisonExpression.Operator.EQUAL));
            }
            PlanNode rewrittenSource = context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(this.metadata, sourceConjuncts));
            PlanNode rewrittenFilteringSource = context.rewrite(node.getFilteringSource(), ExpressionUtils.combineConjuncts(this.metadata, filteringSourceConjuncts));
            PlanNode output = node;
            if (rewrittenSource != node.getSource() || rewrittenFilteringSource != node.getFilteringSource() || !var18_24.equals(node.getDynamicFilterId())) {
                output = new SemiJoinNode(node.getId(), rewrittenSource, rewrittenFilteringSource, node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput(), node.getSourceHashSymbol(), node.getFilteringSourceHashSymbol(), node.getDistributionType(), (Optional<DynamicFilterId>)var18_24);
            }
            if (!postJoinConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), output, ExpressionUtils.combineConjuncts(this.metadata, postJoinConjuncts));
            }
            return output;
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            if (node.hasEmptyGroupingSet()) {
                return this.visitPlan((PlanNode)node, context);
            }
            Expression inheritedPredicate = context.get();
            EqualityInference equalityInference = EqualityInference.newInstance(this.metadata, inheritedPredicate);
            ArrayList<Expression> pushdownConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postAggregationConjuncts = new ArrayList<Expression>();
            ExpressionUtils.extractConjuncts(inheritedPredicate).stream().filter(expression -> !DeterminismEvaluator.isDeterministic(expression, this.metadata)).forEach(postAggregationConjuncts::add);
            inheritedPredicate = ExpressionUtils.filterDeterministicConjuncts(this.metadata, inheritedPredicate);
            ImmutableSet groupingKeys = ImmutableSet.copyOf(node.getGroupingKeys());
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(this.metadata, inheritedPredicate)) {
                if (node.getGroupIdSymbol().isPresent() && SymbolsExtractor.extractUnique(conjunct).contains(node.getGroupIdSymbol().get())) {
                    postAggregationConjuncts.add(conjunct);
                    continue;
                }
                Expression rewrittenConjunct = equalityInference.rewrite(conjunct, (Set<Symbol>)groupingKeys);
                if (rewrittenConjunct != null) {
                    pushdownConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postAggregationConjuncts.add(conjunct);
            }
            EqualityInference.EqualityPartition equalityPartition = equalityInference.generateEqualitiesPartitionedBy((Set<Symbol>)groupingKeys);
            pushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postAggregationConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postAggregationConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(this.metadata, pushdownConjuncts));
            PlanNode output = node;
            if (rewrittenSource != node.getSource()) {
                output = new AggregationNode(node.getId(), rewrittenSource, node.getAggregations(), node.getGroupingSets(), (List<Symbol>)ImmutableList.of(), node.getStep(), node.getHashSymbol(), node.getGroupIdSymbol());
            }
            if (!postAggregationConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), output, ExpressionUtils.combineConjuncts(this.metadata, postAggregationConjuncts));
            }
            return output;
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression inheritedPredicate = context.get();
            if (node.getJoinType() == JoinNode.Type.RIGHT || node.getJoinType() == JoinNode.Type.FULL) {
                return new FilterNode(this.idAllocator.getNextId(), node, inheritedPredicate);
            }
            EqualityInference equalityInference = EqualityInference.newInstance(this.metadata, inheritedPredicate);
            ArrayList<Expression> pushdownConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postUnnestConjuncts = new ArrayList<Expression>();
            ExpressionUtils.extractConjuncts(inheritedPredicate).stream().filter(expression -> !DeterminismEvaluator.isDeterministic(expression, this.metadata)).forEach(postUnnestConjuncts::add);
            inheritedPredicate = ExpressionUtils.filterDeterministicConjuncts(this.metadata, inheritedPredicate);
            ImmutableSet replicatedSymbols = ImmutableSet.copyOf(node.getReplicateSymbols());
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(this.metadata, inheritedPredicate)) {
                Expression rewrittenConjunct = equalityInference.rewrite(conjunct, (Set<Symbol>)replicatedSymbols);
                if (rewrittenConjunct != null) {
                    pushdownConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postUnnestConjuncts.add(conjunct);
            }
            EqualityInference.EqualityPartition equalityPartition = equalityInference.generateEqualitiesPartitionedBy((Set<Symbol>)replicatedSymbols);
            pushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postUnnestConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postUnnestConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(this.metadata, pushdownConjuncts));
            PlanNode output = node;
            if (rewrittenSource != node.getSource()) {
                output = new UnnestNode(node.getId(), rewrittenSource, node.getReplicateSymbols(), node.getMappings(), node.getOrdinalitySymbol(), node.getJoinType(), node.getFilter());
            }
            if (!postUnnestConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), output, ExpressionUtils.combineConjuncts(this.metadata, postUnnestConjuncts));
            }
            return output;
        }

        @Override
        public PlanNode visitSample(SampleNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression predicate = this.simplifyExpression(context.get());
            if (!BooleanLiteral.TRUE_LITERAL.equals((Object)predicate)) {
                return new FilterNode(this.idAllocator.getNextId(), node, predicate);
            }
            return node;
        }

        @Override
        public PlanNode visitAssignUniqueId(AssignUniqueId node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Set<Symbol> predicateSymbols = SymbolsExtractor.extractUnique(context.get());
            Preconditions.checkState((!predicateSymbols.contains(node.getIdColumn()) ? 1 : 0) != 0, (Object)"UniqueId in predicate is not yet supported");
            return context.defaultRewrite(node, context.get());
        }

        private static /* synthetic */ boolean lambda$visitMarkDistinct$11(Set pushDownableSymbols, Expression conjunct) {
            return SymbolsExtractor.extractUnique(conjunct).stream().allMatch(pushDownableSymbols::contains);
        }

        private static class InnerJoinPushDownResult {
            private final Expression leftPredicate;
            private final Expression rightPredicate;
            private final Expression joinPredicate;
            private final Expression postJoinPredicate;

            private InnerJoinPushDownResult(Expression leftPredicate, Expression rightPredicate, Expression joinPredicate, Expression postJoinPredicate) {
                this.leftPredicate = leftPredicate;
                this.rightPredicate = rightPredicate;
                this.joinPredicate = joinPredicate;
                this.postJoinPredicate = postJoinPredicate;
            }

            private Expression getLeftPredicate() {
                return this.leftPredicate;
            }

            private Expression getRightPredicate() {
                return this.rightPredicate;
            }

            private Expression getJoinPredicate() {
                return this.joinPredicate;
            }

            private Expression getPostJoinPredicate() {
                return this.postJoinPredicate;
            }
        }

        private static class OuterJoinPushDownResult {
            private final Expression outerJoinPredicate;
            private final Expression innerJoinPredicate;
            private final Expression joinPredicate;
            private final Expression postJoinPredicate;

            private OuterJoinPushDownResult(Expression outerJoinPredicate, Expression innerJoinPredicate, Expression joinPredicate, Expression postJoinPredicate) {
                this.outerJoinPredicate = outerJoinPredicate;
                this.innerJoinPredicate = innerJoinPredicate;
                this.joinPredicate = joinPredicate;
                this.postJoinPredicate = postJoinPredicate;
            }

            private Expression getOuterJoinPredicate() {
                return this.outerJoinPredicate;
            }

            private Expression getInnerJoinPredicate() {
                return this.innerJoinPredicate;
            }

            public Expression getJoinPredicate() {
                return this.joinPredicate;
            }

            private Expression getPostJoinPredicate() {
                return this.postJoinPredicate;
            }
        }

        private static class DynamicFiltersResult {
            private final Map<DynamicFilterId, Symbol> dynamicFilters;
            private final List<Expression> predicates;

            public DynamicFiltersResult(Map<DynamicFilterId, Symbol> dynamicFilters, List<Expression> predicates) {
                this.dynamicFilters = ImmutableMap.copyOf(dynamicFilters);
                this.predicates = ImmutableList.copyOf(predicates);
            }

            public Map<DynamicFilterId, Symbol> getDynamicFilters() {
                return this.dynamicFilters;
            }

            public List<Expression> getPredicates() {
                return this.predicates;
            }
        }

        private static class DynamicFilterExpression {
            private final ComparisonExpression comparison;
            private final boolean nullAllowed;

            private DynamicFilterExpression(ComparisonExpression comparison) {
                this(comparison, false);
            }

            private DynamicFilterExpression(ComparisonExpression comparison, boolean nullAllowed) {
                this.comparison = Objects.requireNonNull(comparison, "comparison is null");
                this.nullAllowed = nullAllowed;
            }

            public ComparisonExpression getComparison() {
                return this.comparison;
            }

            public boolean isNullAllowed() {
                return this.nullAllowed;
            }
        }
    }
}

