/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ExplainAnalyzeNode
extends PlanNode {
    private final PlanNode source;
    private final Symbol outputSymbol;
    private final List<Symbol> actualOutputs;
    private final boolean verbose;

    @JsonCreator
    public ExplainAnalyzeNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="outputSymbol") Symbol outputSymbol, @JsonProperty(value="actualOutputs") List<Symbol> actualOutputs, @JsonProperty(value="verbose") boolean verbose) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.outputSymbol = Objects.requireNonNull(outputSymbol, "outputSymbol is null");
        Objects.requireNonNull(actualOutputs, "actualOutputs is null");
        Preconditions.checkArgument((boolean)ImmutableSet.copyOf(source.getOutputSymbols()).containsAll(actualOutputs), (Object)"Source does not supply all required input symbols");
        this.actualOutputs = ImmutableList.copyOf(actualOutputs);
        this.verbose = verbose;
    }

    @JsonProperty(value="outputSymbol")
    public Symbol getOutputSymbol() {
        return this.outputSymbol;
    }

    @JsonProperty(value="actualOutputs")
    public List<Symbol> getActualOutputs() {
        return this.actualOutputs;
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty(value="verbose")
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.of((Object)this.outputSymbol);
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitExplainAnalyze(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new ExplainAnalyzeNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.outputSymbol, this.actualOutputs, this.isVerbose());
    }
}

