/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.relational;

import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.ComparisonExpression;
import java.util.List;
import java.util.Objects;

public final class StandardFunctionResolution {
    private final Metadata metadata;

    public StandardFunctionResolution(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public ResolvedFunction arithmeticFunction(ArithmeticBinaryExpression.Operator operator, Type leftType, Type rightType) {
        OperatorType operatorType;
        switch (operator) {
            case ADD: {
                operatorType = OperatorType.ADD;
                break;
            }
            case SUBTRACT: {
                operatorType = OperatorType.SUBTRACT;
                break;
            }
            case MULTIPLY: {
                operatorType = OperatorType.MULTIPLY;
                break;
            }
            case DIVIDE: {
                operatorType = OperatorType.DIVIDE;
                break;
            }
            case MODULUS: {
                operatorType = OperatorType.MODULUS;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown arithmetic operator: " + operator);
            }
        }
        return this.metadata.resolveOperator(operatorType, (List<? extends Type>)ImmutableList.of((Object)leftType, (Object)rightType));
    }

    public ResolvedFunction comparisonFunction(ComparisonExpression.Operator operator, Type leftType, Type rightType) {
        OperatorType operatorType;
        switch (operator) {
            case EQUAL: {
                operatorType = OperatorType.EQUAL;
                break;
            }
            case LESS_THAN: {
                operatorType = OperatorType.LESS_THAN;
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                operatorType = OperatorType.LESS_THAN_OR_EQUAL;
                break;
            }
            case IS_DISTINCT_FROM: {
                operatorType = OperatorType.IS_DISTINCT_FROM;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported comparison operator type: " + operator);
            }
        }
        return this.metadata.resolveOperator(operatorType, (List<? extends Type>)ImmutableList.of((Object)leftType, (Object)rightType));
    }
}

