/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MaterializedRow {
    private final int precision;
    private final List<?> values;

    public MaterializedRow(int precision, Object ... values) {
        this(precision, Arrays.asList(Objects.requireNonNull(values, "values is null")));
    }

    public MaterializedRow(List<Object> values) {
        this(5, values);
    }

    public MaterializedRow(int precision, List<Object> values) {
        Preconditions.checkArgument((precision > 0 ? 1 : 0) != 0, (Object)"Need at least one digit of precision");
        this.precision = precision;
        this.values = (List)MaterializedRow.processValue(precision, values);
    }

    private static Object processValue(int precision, Object value) {
        if (value instanceof Double) {
            return new ApproximateDouble((Double)value, precision);
        }
        if (value instanceof Float) {
            return new ApproximateFloat((Float)value, precision);
        }
        if (value instanceof List) {
            return ((List)value).stream().map(element -> MaterializedRow.processValue(precision, element)).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                map.put(MaterializedRow.processValue(precision, entry.getKey()), MaterializedRow.processValue(precision, entry.getValue()));
            }
            return map;
        }
        if (value instanceof byte[]) {
            return ByteBuffer.wrap((byte[])value);
        }
        return value;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getFieldCount() {
        return this.values.size();
    }

    public List<Object> getFields() {
        return this.values.stream().map(MaterializedRow::processField).collect(Collectors.toList());
    }

    public Object getField(int field) {
        Preconditions.checkElementIndex((int)field, (int)this.values.size());
        return MaterializedRow.processField(this.values.get(field));
    }

    private static Object processField(Object value) {
        if (value instanceof ApproximateNumeric) {
            return ((ApproximateNumeric)value).getValue();
        }
        if (value instanceof List) {
            return ((List)value).stream().map(MaterializedRow::processField).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                map.put(MaterializedRow.processField(entry.getKey()), MaterializedRow.processField(entry.getValue()));
            }
            return map;
        }
        if (value instanceof ByteBuffer) {
            return ((ByteBuffer)value).array();
        }
        return value;
    }

    public String toString() {
        return this.values.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MaterializedRow o = (MaterializedRow)obj;
        return Objects.equals(this.values, o.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    private static class ApproximateFloat
    extends ApproximateNumeric {
        private final Float value;
        private final int precision;

        private ApproximateFloat(Float value, int precision) {
            this.value = Objects.requireNonNull(value, "value is null");
            this.precision = precision;
        }

        @Override
        public Number getValue() {
            return this.value;
        }

        @Override
        protected Number getNormalizedValue() {
            if (this.value.isNaN() || this.value.isInfinite()) {
                return this.value;
            }
            return Float.valueOf(new BigDecimal(this.getValue().floatValue()).round(new MathContext(this.precision)).floatValue());
        }
    }

    private static class ApproximateDouble
    extends ApproximateNumeric {
        private final Double value;
        private final int precision;

        private ApproximateDouble(Double value, int precision) {
            this.value = Objects.requireNonNull(value, "value is null");
            this.precision = precision;
        }

        @Override
        public Number getValue() {
            return this.value;
        }

        @Override
        protected Number getNormalizedValue() {
            if (this.value.isNaN() || this.value.isInfinite()) {
                return this.value;
            }
            return new BigDecimal(this.getValue().doubleValue()).round(new MathContext(this.precision)).doubleValue();
        }
    }

    private static abstract class ApproximateNumeric {
        private ApproximateNumeric() {
        }

        public abstract Number getValue();

        protected abstract Number getNormalizedValue();

        public String toString() {
            return this.getValue().toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ApproximateNumeric o = (ApproximateNumeric)obj;
            return Objects.equals(this.getNormalizedValue(), o.getNormalizedValue());
        }

        public int hashCode() {
            return Objects.hash(this.getNormalizedValue());
        }
    }
}

