/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.operator.scalar.ColorFunctions;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.AbstractIntType;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;

public class ColorType
extends AbstractIntType {
    public static final ColorType COLOR = new ColorType();
    public static final String NAME = "color";

    private ColorType() {
        super(new TypeSignature(NAME, new TypeSignatureParameter[0]));
    }

    public boolean isOrderable() {
        return false;
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        int color = block.getInt(position, 0);
        if (color < 0) {
            return ColorFunctions.SystemColor.valueOf(-(color + 1)).getName();
        }
        return String.format("#%02x%02x%02x", color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
    }

    public boolean equals(Object other) {
        return other == COLOR;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

