/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.util.DateTimeUtils;

public final class DateOperators {
    private DateOperators() {
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToSlice(@SqlType(value="date") long value) {
        return Slices.utf8Slice((String)DateTimeUtils.printDate((int)value));
    }

    @ScalarFunction(value="date")
    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="date")
    public static long castFromSlice(@SqlType(value="varchar(x)") Slice value) {
        try {
            return DateTimeUtils.parseDate(SliceUtf8.trim((Slice)value).toStringUtf8());
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to date: " + value.toStringUtf8(), (Throwable)e);
        }
    }
}

