/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.metadata.Metadata;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeId;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.spi.type.TypeSignature;
import java.util.Objects;
import javax.inject.Inject;

public final class InternalTypeManager
implements TypeManager {
    private final Metadata metadata;
    private final TypeOperators typeOperators;

    @Inject
    public InternalTypeManager(Metadata metadata, TypeOperators typeOperators) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
    }

    public Type getType(TypeSignature signature) {
        return this.metadata.getType(signature);
    }

    public Type fromSqlType(String type) {
        return this.metadata.fromSqlType(type);
    }

    public Type getType(TypeId id) {
        return this.metadata.getType(id);
    }

    public TypeOperators getTypeOperators() {
        return this.typeOperators;
    }
}

