/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.FixedWidthType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.List;

public final class TypeUtils {
    public static final int NULL_HASH_CODE = 0;

    private TypeUtils() {
    }

    public static int expectedValueSize(Type type, int defaultSize) {
        if (type instanceof FixedWidthType) {
            return ((FixedWidthType)type).getFixedSize();
        }
        if (type instanceof VarcharType) {
            return ((VarcharType)type).getLength().map(length -> Math.min(length, defaultSize)).orElse(defaultSize);
        }
        if (type instanceof CharType) {
            return Math.min(((CharType)type).getLength(), defaultSize);
        }
        return defaultSize;
    }

    public static void checkElementNotNull(boolean isNull, String errorMsg) {
        if (isNull) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, errorMsg);
        }
    }

    public static String getDisplayLabel(Type type, boolean legacy) {
        if (legacy) {
            return TypeUtils.getDisplayLabelForLegacyClients(type);
        }
        return type.getDisplayName();
    }

    private static String getDisplayLabelForLegacyClients(Type type) {
        if (type instanceof TimestampType && ((TimestampType)type).getPrecision() == 3) {
            return "timestamp";
        }
        if (type instanceof TimestampWithTimeZoneType && ((TimestampWithTimeZoneType)type).getPrecision() == 3) {
            return "timestamp with time zone";
        }
        if (type instanceof TimeType && ((TimeType)type).getPrecision() == 3) {
            return "time";
        }
        if (type instanceof TimeWithTimeZoneType && ((TimeWithTimeZoneType)type).getPrecision() == 3) {
            return "time with time zone";
        }
        if (type instanceof ArrayType) {
            return "array(" + TypeUtils.getDisplayLabelForLegacyClients(((ArrayType)type).getElementType()) + ")";
        }
        if (type instanceof MapType) {
            return "map(" + TypeUtils.getDisplayLabelForLegacyClients(((MapType)type).getKeyType()) + ", " + TypeUtils.getDisplayLabelForLegacyClients(((MapType)type).getValueType()) + ")";
        }
        if (type instanceof RowType) {
            return TypeUtils.getRowDisplayLabelForLegacyClients((RowType)type);
        }
        return type.getDisplayName();
    }

    private static String getRowDisplayLabelForLegacyClients(RowType type) {
        List fields = (List)type.getFields().stream().map(field -> {
            String typeDisplayName = TypeUtils.getDisplayLabelForLegacyClients(field.getType());
            if (field.getName().isPresent()) {
                return (String)field.getName().get() + " " + typeDisplayName;
            }
            return typeDisplayName;
        }).collect(ImmutableList.toImmutableList());
        return String.format("%s(%s)", "row", Joiner.on((String)", ").join((Iterable)fields));
    }
}

