/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.util;

import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.resourcegroups.QueryType;
import io.prestosql.sql.tree.AddColumn;
import io.prestosql.sql.tree.Analyze;
import io.prestosql.sql.tree.Call;
import io.prestosql.sql.tree.Comment;
import io.prestosql.sql.tree.Commit;
import io.prestosql.sql.tree.CreateMaterializedView;
import io.prestosql.sql.tree.CreateRole;
import io.prestosql.sql.tree.CreateSchema;
import io.prestosql.sql.tree.CreateTable;
import io.prestosql.sql.tree.CreateTableAsSelect;
import io.prestosql.sql.tree.CreateView;
import io.prestosql.sql.tree.Deallocate;
import io.prestosql.sql.tree.Delete;
import io.prestosql.sql.tree.DescribeInput;
import io.prestosql.sql.tree.DescribeOutput;
import io.prestosql.sql.tree.DropColumn;
import io.prestosql.sql.tree.DropMaterializedView;
import io.prestosql.sql.tree.DropRole;
import io.prestosql.sql.tree.DropSchema;
import io.prestosql.sql.tree.DropTable;
import io.prestosql.sql.tree.DropView;
import io.prestosql.sql.tree.Explain;
import io.prestosql.sql.tree.Grant;
import io.prestosql.sql.tree.GrantRoles;
import io.prestosql.sql.tree.Insert;
import io.prestosql.sql.tree.Prepare;
import io.prestosql.sql.tree.Query;
import io.prestosql.sql.tree.RefreshMaterializedView;
import io.prestosql.sql.tree.RenameColumn;
import io.prestosql.sql.tree.RenameSchema;
import io.prestosql.sql.tree.RenameTable;
import io.prestosql.sql.tree.RenameView;
import io.prestosql.sql.tree.ResetSession;
import io.prestosql.sql.tree.Revoke;
import io.prestosql.sql.tree.RevokeRoles;
import io.prestosql.sql.tree.Rollback;
import io.prestosql.sql.tree.SetPath;
import io.prestosql.sql.tree.SetRole;
import io.prestosql.sql.tree.SetSchemaAuthorization;
import io.prestosql.sql.tree.SetSession;
import io.prestosql.sql.tree.SetTableAuthorization;
import io.prestosql.sql.tree.SetViewAuthorization;
import io.prestosql.sql.tree.ShowCatalogs;
import io.prestosql.sql.tree.ShowColumns;
import io.prestosql.sql.tree.ShowCreate;
import io.prestosql.sql.tree.ShowFunctions;
import io.prestosql.sql.tree.ShowGrants;
import io.prestosql.sql.tree.ShowRoleGrants;
import io.prestosql.sql.tree.ShowRoles;
import io.prestosql.sql.tree.ShowSchemas;
import io.prestosql.sql.tree.ShowSession;
import io.prestosql.sql.tree.ShowStats;
import io.prestosql.sql.tree.ShowTables;
import io.prestosql.sql.tree.StartTransaction;
import io.prestosql.sql.tree.Statement;
import io.prestosql.sql.tree.Use;
import java.util.Map;
import java.util.Optional;

public final class StatementUtils {
    private static final Map<Class<? extends Statement>, QueryType> STATEMENT_QUERY_TYPES;

    private StatementUtils() {
    }

    public static Map<Class<? extends Statement>, QueryType> getAllQueryTypes() {
        return STATEMENT_QUERY_TYPES;
    }

    public static Optional<QueryType> getQueryType(Class<? extends Statement> statement) {
        return Optional.ofNullable(STATEMENT_QUERY_TYPES.get(statement));
    }

    public static boolean isTransactionControlStatement(Statement statement) {
        return statement instanceof StartTransaction || statement instanceof Commit || statement instanceof Rollback;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(Query.class, (Object)QueryType.SELECT);
        builder.put(Explain.class, (Object)QueryType.EXPLAIN);
        builder.put(Analyze.class, (Object)QueryType.ANALYZE);
        builder.put(CreateTableAsSelect.class, (Object)QueryType.INSERT);
        builder.put(Insert.class, (Object)QueryType.INSERT);
        builder.put(Delete.class, (Object)QueryType.DELETE);
        builder.put(ShowCatalogs.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowCreate.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowFunctions.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowGrants.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowRoles.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowRoleGrants.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowSchemas.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowSession.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowStats.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowTables.class, (Object)QueryType.DESCRIBE);
        builder.put(ShowColumns.class, (Object)QueryType.DESCRIBE);
        builder.put(DescribeInput.class, (Object)QueryType.DESCRIBE);
        builder.put(DescribeOutput.class, (Object)QueryType.DESCRIBE);
        builder.put(CreateSchema.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(DropSchema.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(RenameSchema.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(SetSchemaAuthorization.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(AddColumn.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(SetTableAuthorization.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(CreateTable.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(RenameTable.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(Comment.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(RenameColumn.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(DropColumn.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(DropTable.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(CreateView.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(RenameView.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(SetViewAuthorization.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(DropView.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(CreateMaterializedView.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(RefreshMaterializedView.class, (Object)QueryType.INSERT);
        builder.put(DropMaterializedView.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(Use.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(SetSession.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(ResetSession.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(StartTransaction.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(Commit.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(Rollback.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(Call.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(CreateRole.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(DropRole.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(GrantRoles.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(RevokeRoles.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(SetRole.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(Grant.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(Revoke.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(Prepare.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(Deallocate.class, (Object)QueryType.DATA_DEFINITION);
        builder.put(SetPath.class, (Object)QueryType.DATA_DEFINITION);
        STATEMENT_QUERY_TYPES = builder.build();
    }
}

