/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.memory;

import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.testing.Closeables;
import io.prestosql.Session;
import io.prestosql.plugin.memory.MemoryPlugin;
import io.prestosql.plugin.tpch.TpchPlugin;
import io.prestosql.spi.Plugin;
import io.prestosql.testing.DistributedQueryRunner;
import io.prestosql.testing.QueryAssertions;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.TestingSession;
import io.prestosql.tpch.TpchTable;
import java.util.Map;

public final class MemoryQueryRunner {
    private static final String CATALOG = "memory";

    private MemoryQueryRunner() {
    }

    public static DistributedQueryRunner createQueryRunner() throws Exception {
        return MemoryQueryRunner.createQueryRunner((Map<String, String>)ImmutableMap.of());
    }

    public static DistributedQueryRunner createQueryRunner(Map<String, String> extraProperties) throws Exception {
        Session session = TestingSession.testSessionBuilder().setCatalog(CATALOG).setSchema("default").build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).setExtraProperties(extraProperties).build();
        try {
            queryRunner.installPlugin((Plugin)new MemoryPlugin());
            queryRunner.createCatalog(CATALOG, CATALOG, (Map)ImmutableMap.of());
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog("tpch", "tpch", (Map)ImmutableMap.of());
            QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", (Session)session, (Iterable)TpchTable.getTables());
            return queryRunner;
        }
        catch (Exception e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        Logging.initialize();
        DistributedQueryRunner queryRunner = MemoryQueryRunner.createQueryRunner((Map<String, String>)ImmutableMap.of((Object)"http-server.http.port", (Object)"8080"));
        Thread.sleep(10L);
        Logger log = Logger.get(MemoryQueryRunner.class);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }
}

