/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.memory.MemoryMetadata;
import io.prestosql.plugin.memory.MemoryOutputTableHandle;
import io.prestosql.plugin.memory.MemoryTableHandle;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.connector.SchemaNotFoundException;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.testing.QueryAssertions;
import io.prestosql.testing.TestingConnectorSession;
import io.prestosql.testing.TestingNodeManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestMemoryMetadata {
    private MemoryMetadata metadata;

    @BeforeMethod
    public void setUp() {
        this.metadata = new MemoryMetadata((NodeManager)new TestingNodeManager());
    }

    @Test
    public void tableIsCreatedAfterCommits() {
        this.assertNoTables();
        SchemaTableName schemaTableName = new SchemaTableName("default", "temp_table");
        MemoryOutputTableHandle table = this.metadata.beginCreateTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(schemaTableName, (List)ImmutableList.of(), (Map)ImmutableMap.of()), Optional.empty());
        this.metadata.finishCreateTable(TestingConnectorSession.SESSION, (ConnectorOutputTableHandle)table, (Collection)ImmutableList.of(), (Collection)ImmutableList.of());
        List tables = this.metadata.listTables(TestingConnectorSession.SESSION, Optional.empty());
        Assert.assertEquals((int)tables.size(), (int)1, (String)"Expected only one table");
        Assert.assertEquals((String)((SchemaTableName)tables.get(0)).getTableName(), (String)"temp_table", (String)"Expected table with name 'temp_table'");
    }

    @Test
    public void tableAlreadyExists() {
        this.assertNoTables();
        SchemaTableName test1Table = new SchemaTableName("default", "test1");
        SchemaTableName test2Table = new SchemaTableName("default", "test2");
        this.metadata.createTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(test1Table, (List)ImmutableList.of()), false);
        try {
            this.metadata.createTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(test1Table, (List)ImmutableList.of()), false);
            Assert.fail((String)"Should fail because table already exists");
        }
        catch (PrestoException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)StandardErrorCode.ALREADY_EXISTS.toErrorCode());
            Assert.assertEquals((String)ex.getMessage(), (String)"Table [default.test1] already exists");
        }
        ConnectorTableHandle test1TableHandle = this.metadata.getTableHandle(TestingConnectorSession.SESSION, test1Table);
        this.metadata.createTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(test2Table, (List)ImmutableList.of()), false);
        try {
            this.metadata.renameTable(TestingConnectorSession.SESSION, test1TableHandle, test2Table);
            Assert.fail((String)"Should fail because table already exists");
        }
        catch (PrestoException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)StandardErrorCode.ALREADY_EXISTS.toErrorCode());
            Assert.assertEquals((String)ex.getMessage(), (String)"Table [default.test2] already exists");
        }
    }

    @Test
    public void testActiveTableIds() {
        this.assertNoTables();
        SchemaTableName firstTableName = new SchemaTableName("default", "first_table");
        this.metadata.createTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(firstTableName, (List)ImmutableList.of(), (Map)ImmutableMap.of()), false);
        MemoryTableHandle firstTableHandle = (MemoryTableHandle)this.metadata.getTableHandle(TestingConnectorSession.SESSION, firstTableName);
        long firstTableId = firstTableHandle.getId();
        Assert.assertTrue((boolean)this.metadata.beginInsert(TestingConnectorSession.SESSION, (ConnectorTableHandle)firstTableHandle, (List)ImmutableList.of()).getActiveTableIds().contains(firstTableId));
        SchemaTableName secondTableName = new SchemaTableName("default", "second_table");
        this.metadata.createTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(secondTableName, (List)ImmutableList.of(), (Map)ImmutableMap.of()), false);
        MemoryTableHandle secondTableHandle = (MemoryTableHandle)this.metadata.getTableHandle(TestingConnectorSession.SESSION, secondTableName);
        long secondTableId = secondTableHandle.getId();
        Assert.assertNotEquals((Object)firstTableId, (Object)secondTableId);
        Assert.assertTrue((boolean)this.metadata.beginInsert(TestingConnectorSession.SESSION, (ConnectorTableHandle)secondTableHandle, (List)ImmutableList.of()).getActiveTableIds().contains(firstTableId));
        Assert.assertTrue((boolean)this.metadata.beginInsert(TestingConnectorSession.SESSION, (ConnectorTableHandle)secondTableHandle, (List)ImmutableList.of()).getActiveTableIds().contains(secondTableId));
    }

    @Test
    public void testReadTableBeforeCreationCompleted() {
        this.assertNoTables();
        SchemaTableName tableName = new SchemaTableName("default", "temp_table");
        MemoryOutputTableHandle table = this.metadata.beginCreateTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(tableName, (List)ImmutableList.of(), (Map)ImmutableMap.of()), Optional.empty());
        List tableNames = this.metadata.listTables(TestingConnectorSession.SESSION, Optional.empty());
        Assert.assertEquals((int)tableNames.size(), (int)1, (String)"Expected exactly one table");
        this.metadata.finishCreateTable(TestingConnectorSession.SESSION, (ConnectorOutputTableHandle)table, (Collection)ImmutableList.of(), (Collection)ImmutableList.of());
    }

    @Test
    public void testCreateSchema() {
        Assert.assertEquals((Collection)this.metadata.listSchemaNames(TestingConnectorSession.SESSION), (Collection)ImmutableList.of((Object)"default"));
        this.metadata.createSchema(TestingConnectorSession.SESSION, "test", (Map)ImmutableMap.of(), new PrestoPrincipal(PrincipalType.USER, TestingConnectorSession.SESSION.getUser()));
        Assert.assertEquals((Collection)this.metadata.listSchemaNames(TestingConnectorSession.SESSION), (Collection)ImmutableList.of((Object)"default", (Object)"test"));
        Assert.assertEquals((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("test")), (Collection)ImmutableList.of());
        SchemaTableName tableName = new SchemaTableName("test", "first_table");
        this.metadata.createTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(tableName, (List)ImmutableList.of(), (Map)ImmutableMap.of()), false);
        Assert.assertEquals((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.empty()), (Collection)ImmutableList.of((Object)tableName));
        Assert.assertEquals((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("test")), (Collection)ImmutableList.of((Object)tableName));
        Assert.assertEquals((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("default")), (Collection)ImmutableList.of());
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="View already exists: test\\.test_view")
    public void testCreateViewWithoutReplace() {
        SchemaTableName test = new SchemaTableName("test", "test_view");
        this.metadata.createSchema(TestingConnectorSession.SESSION, "test", (Map)ImmutableMap.of(), new PrestoPrincipal(PrincipalType.USER, TestingConnectorSession.SESSION.getUser()));
        try {
            this.metadata.createView(TestingConnectorSession.SESSION, test, TestMemoryMetadata.testingViewDefinition("test"), false);
        }
        catch (Exception e) {
            Assert.fail((String)"should have succeeded");
        }
        this.metadata.createView(TestingConnectorSession.SESSION, test, TestMemoryMetadata.testingViewDefinition("test"), false);
    }

    @Test
    public void testCreateViewWithReplace() {
        SchemaTableName test = new SchemaTableName("test", "test_view");
        this.metadata.createSchema(TestingConnectorSession.SESSION, "test", (Map)ImmutableMap.of(), new PrestoPrincipal(PrincipalType.USER, TestingConnectorSession.SESSION.getUser()));
        this.metadata.createView(TestingConnectorSession.SESSION, test, TestMemoryMetadata.testingViewDefinition("aaa"), true);
        this.metadata.createView(TestingConnectorSession.SESSION, test, TestMemoryMetadata.testingViewDefinition("bbb"), true);
        Assertions.assertThat((Optional)this.metadata.getView(TestingConnectorSession.SESSION, test)).map(ConnectorViewDefinition::getOriginalSql).hasValue((Object)"bbb");
    }

    @Test
    public void testCreatedViewShouldBeListedAsTable() {
        String schemaName = "test";
        SchemaTableName viewName = new SchemaTableName(schemaName, "test_view");
        this.metadata.createSchema(TestingConnectorSession.SESSION, schemaName, (Map)ImmutableMap.of(), new PrestoPrincipal(PrincipalType.USER, TestingConnectorSession.SESSION.getUser()));
        this.metadata.createView(TestingConnectorSession.SESSION, viewName, TestMemoryMetadata.testingViewDefinition("aaa"), true);
        Assertions.assertThat((List)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of(schemaName))).contains((Object[])new SchemaTableName[]{viewName});
    }

    @Test
    public void testViews() {
        SchemaTableName test1 = new SchemaTableName("test", "test_view1");
        SchemaTableName test2 = new SchemaTableName("test", "test_view2");
        SchemaTableName test3 = new SchemaTableName("test", "test_view3");
        this.metadata.createSchema(TestingConnectorSession.SESSION, "test", (Map)ImmutableMap.of(), new PrestoPrincipal(PrincipalType.USER, TestingConnectorSession.SESSION.getUser()));
        this.metadata.createView(TestingConnectorSession.SESSION, test1, TestMemoryMetadata.testingViewDefinition("test1"), false);
        this.metadata.createView(TestingConnectorSession.SESSION, test2, TestMemoryMetadata.testingViewDefinition("test2"), false);
        List list = this.metadata.listViews(TestingConnectorSession.SESSION, Optional.of("test"));
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)list, (Iterable)ImmutableList.of((Object)test1, (Object)test2));
        Map views = this.metadata.getViews(TestingConnectorSession.SESSION, Optional.of("test"));
        Assert.assertEquals(views.keySet(), (Set)ImmutableSet.of((Object)test1, (Object)test2));
        Assert.assertEquals((String)((ConnectorViewDefinition)views.get(test1)).getOriginalSql(), (String)"test1");
        Assert.assertEquals((String)((ConnectorViewDefinition)views.get(test2)).getOriginalSql(), (String)"test2");
        Assertions.assertThat((Map)this.metadata.getViews(TestingConnectorSession.SESSION, Optional.empty())).containsOnlyKeys((Object[])new SchemaTableName[]{test1, test2});
        Assertions.assertThat((Optional)this.metadata.getView(TestingConnectorSession.SESSION, new SchemaTableName("test", "test_view1"))).map(ConnectorViewDefinition::getOriginalSql).contains((Object)"test1");
        Assertions.assertThat((Optional)this.metadata.getView(TestingConnectorSession.SESSION, new SchemaTableName("test", "nonexistenttable"))).isEmpty();
        Assertions.assertThat((Map)this.metadata.getViews(TestingConnectorSession.SESSION, Optional.of("nonexistentschema"))).isEmpty();
        this.metadata.dropView(TestingConnectorSession.SESSION, test1);
        Assertions.assertThat((Map)this.metadata.getViews(TestingConnectorSession.SESSION, Optional.of("test"))).containsOnlyKeys((Object[])new SchemaTableName[]{test2});
        this.metadata.renameView(TestingConnectorSession.SESSION, test2, test3);
        Assertions.assertThat((Map)this.metadata.getViews(TestingConnectorSession.SESSION, Optional.of("test"))).containsOnlyKeys((Object[])new SchemaTableName[]{test3});
        this.metadata.dropView(TestingConnectorSession.SESSION, test3);
        Assertions.assertThat((Map)this.metadata.getViews(TestingConnectorSession.SESSION, Optional.of("test"))).isEmpty();
        Assertions.assertThat((Map)this.metadata.getViews(TestingConnectorSession.SESSION, Optional.empty())).isEmpty();
    }

    @Test
    public void testCreateTableAndViewInNotExistSchema() {
        Assert.assertEquals((Collection)this.metadata.listSchemaNames(TestingConnectorSession.SESSION), (Collection)ImmutableList.of((Object)"default"));
        SchemaTableName table1 = new SchemaTableName("test1", "test_schema_table1");
        try {
            this.metadata.beginCreateTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(table1, (List)ImmutableList.of(), (Map)ImmutableMap.of()), Optional.empty());
            Assert.fail((String)"Should fail because schema does not exist");
        }
        catch (PrestoException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)StandardErrorCode.NOT_FOUND.toErrorCode());
            Assert.assertEquals((String)ex.getMessage(), (String)"Schema test1 not found");
        }
        Assert.assertNull((Object)this.metadata.getTableHandle(TestingConnectorSession.SESSION, table1));
        SchemaTableName view2 = new SchemaTableName("test2", "test_schema_view2");
        try {
            this.metadata.createView(TestingConnectorSession.SESSION, view2, TestMemoryMetadata.testingViewDefinition("aaa"), false);
            Assert.fail((String)"Should fail because schema does not exist");
        }
        catch (PrestoException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)StandardErrorCode.NOT_FOUND.toErrorCode());
            Assert.assertEquals((String)ex.getMessage(), (String)"Schema test2 not found");
        }
        Assert.assertNull((Object)this.metadata.getTableHandle(TestingConnectorSession.SESSION, view2));
        SchemaTableName view3 = new SchemaTableName("test3", "test_schema_view3");
        try {
            this.metadata.createView(TestingConnectorSession.SESSION, view3, TestMemoryMetadata.testingViewDefinition("bbb"), true);
            Assert.fail((String)"Should fail because schema does not exist");
        }
        catch (PrestoException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)StandardErrorCode.NOT_FOUND.toErrorCode());
            Assert.assertEquals((String)ex.getMessage(), (String)"Schema test3 not found");
        }
        Assert.assertNull((Object)this.metadata.getTableHandle(TestingConnectorSession.SESSION, view3));
        Assert.assertEquals((Collection)this.metadata.listSchemaNames(TestingConnectorSession.SESSION), (Collection)ImmutableList.of((Object)"default"));
    }

    @Test
    public void testRenameTable() {
        SchemaTableName tableName = new SchemaTableName("test_schema", "test_table_to_be_renamed");
        this.metadata.createSchema(TestingConnectorSession.SESSION, "test_schema", (Map)ImmutableMap.of(), new PrestoPrincipal(PrincipalType.USER, TestingConnectorSession.SESSION.getUser()));
        MemoryOutputTableHandle table = this.metadata.beginCreateTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(tableName, (List)ImmutableList.of(), (Map)ImmutableMap.of()), Optional.empty());
        this.metadata.finishCreateTable(TestingConnectorSession.SESSION, (ConnectorOutputTableHandle)table, (Collection)ImmutableList.of(), (Collection)ImmutableList.of());
        SchemaTableName invalidSchemaTableName = new SchemaTableName("test_schema_not_exist", "test_table_renamed");
        ConnectorTableHandle tableHandle = this.metadata.getTableHandle(TestingConnectorSession.SESSION, tableName);
        Throwable throwable = Assert.expectThrows(SchemaNotFoundException.class, () -> this.metadata.renameTable(TestingConnectorSession.SESSION, tableHandle, invalidSchemaTableName));
        Assert.assertEquals((String)throwable.getMessage(), (String)"Schema test_schema_not_exist not found");
        SchemaTableName sameSchemaTableName = new SchemaTableName("test_schema", "test_renamed");
        this.metadata.renameTable(TestingConnectorSession.SESSION, this.metadata.getTableHandle(TestingConnectorSession.SESSION, tableName), sameSchemaTableName);
        Assert.assertEquals((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("test_schema")), (Collection)ImmutableList.of((Object)sameSchemaTableName));
        this.metadata.createSchema(TestingConnectorSession.SESSION, "test_different_schema", (Map)ImmutableMap.of(), new PrestoPrincipal(PrincipalType.USER, TestingConnectorSession.SESSION.getUser()));
        SchemaTableName differentSchemaTableName = new SchemaTableName("test_different_schema", "test_renamed");
        this.metadata.renameTable(TestingConnectorSession.SESSION, this.metadata.getTableHandle(TestingConnectorSession.SESSION, sameSchemaTableName), differentSchemaTableName);
        Assert.assertEquals((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("test_schema")), (Collection)ImmutableList.of());
        Assert.assertEquals((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("test_different_schema")), (Collection)ImmutableList.of((Object)differentSchemaTableName));
    }

    private void assertNoTables() {
        Assert.assertEquals((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.empty()), (Collection)ImmutableList.of(), (String)"No table was expected");
    }

    private static ConnectorViewDefinition testingViewDefinition(String sql) {
        return new ConnectorViewDefinition(sql, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("test", BigintType.BIGINT.getTypeId())), Optional.empty(), Optional.empty(), true);
    }
}

