/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.prestosql.plugin.memory.MemoryConfig;
import io.prestosql.plugin.memory.MemoryInsertTableHandle;
import io.prestosql.plugin.memory.MemoryOutputTableHandle;
import io.prestosql.plugin.memory.MemoryPageSinkProvider;
import io.prestosql.plugin.memory.MemoryPagesStore;
import io.prestosql.plugin.memory.MemoryTransactionHandle;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorPageSink;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.type.BigintType;
import io.prestosql.testing.TestingConnectorSession;
import java.util.Collection;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestMemoryPagesStore {
    private static final int POSITIONS_PER_PAGE = 0;
    private MemoryPagesStore pagesStore;
    private MemoryPageSinkProvider pageSinkProvider;

    @BeforeMethod
    public void setUp() {
        this.pagesStore = new MemoryPagesStore(new MemoryConfig().setMaxDataPerNode(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
        this.pageSinkProvider = new MemoryPageSinkProvider(this.pagesStore, HostAddress.fromString((String)"localhost:8080"));
    }

    @Test
    public void testCreateEmptyTable() {
        this.createTable(0L, 0L);
        Assert.assertEquals((Collection)this.pagesStore.getPages(Long.valueOf(0L), 0, 1, (List)ImmutableList.of((Object)0), 0L, OptionalLong.empty(), OptionalDouble.empty()), (Collection)ImmutableList.of());
    }

    @Test
    public void testInsertPage() {
        this.createTable(0L, 0L);
        this.insertToTable(0L, 0L);
        Assert.assertEquals((int)this.pagesStore.getPages(Long.valueOf(0L), 0, 1, (List)ImmutableList.of((Object)0), 0L, OptionalLong.empty(), OptionalDouble.empty()).size(), (int)1);
    }

    @Test
    public void testInsertPageWithoutCreate() {
        this.insertToTable(0L, 0L);
        Assert.assertEquals((int)this.pagesStore.getPages(Long.valueOf(0L), 0, 1, (List)ImmutableList.of((Object)0), 0L, OptionalLong.empty(), OptionalDouble.empty()).size(), (int)1);
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testReadFromUnknownTable() {
        this.pagesStore.getPages(Long.valueOf(0L), 0, 1, (List)ImmutableList.of((Object)0), 0L, OptionalLong.empty(), OptionalDouble.empty());
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testTryToReadFromEmptyTable() {
        this.createTable(0L, 0L);
        Assert.assertEquals((Collection)this.pagesStore.getPages(Long.valueOf(0L), 0, 1, (List)ImmutableList.of((Object)0), 0L, OptionalLong.empty(), OptionalDouble.empty()), (Collection)ImmutableList.of());
        this.pagesStore.getPages(Long.valueOf(0L), 0, 1, (List)ImmutableList.of((Object)0), 42L, OptionalLong.empty(), OptionalDouble.empty());
    }

    @Test
    public void testCleanUp() {
        this.createTable(0L, 0L);
        this.createTable(1L, 0L, 1L);
        this.createTable(2L, 0L, 1L, 2L);
        Assert.assertTrue((boolean)this.pagesStore.contains(Long.valueOf(0L)));
        Assert.assertTrue((boolean)this.pagesStore.contains(Long.valueOf(1L)));
        Assert.assertTrue((boolean)this.pagesStore.contains(Long.valueOf(2L)));
        this.insertToTable(1L, 0L, 1L);
        Assert.assertTrue((boolean)this.pagesStore.contains(Long.valueOf(0L)));
        Assert.assertTrue((boolean)this.pagesStore.contains(Long.valueOf(1L)));
        Assert.assertTrue((boolean)this.pagesStore.contains(Long.valueOf(2L)));
        this.insertToTable(2L, 0L, 2L);
        Assert.assertTrue((boolean)this.pagesStore.contains(Long.valueOf(0L)));
        Assert.assertFalse((boolean)this.pagesStore.contains(Long.valueOf(1L)));
        Assert.assertTrue((boolean)this.pagesStore.contains(Long.valueOf(2L)));
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testMemoryLimitExceeded() {
        this.createTable(0L, 0L);
        this.insertToTable(0L, TestMemoryPagesStore.createOneMegaBytePage(), 0L);
        this.insertToTable(0L, TestMemoryPagesStore.createOneMegaBytePage(), 0L);
    }

    private void insertToTable(long tableId, Long ... activeTableIds) {
        this.insertToTable(tableId, TestMemoryPagesStore.createPage(), activeTableIds);
    }

    private void insertToTable(long tableId, Page page, Long ... activeTableIds) {
        ConnectorPageSink pageSink = this.pageSinkProvider.createPageSink((ConnectorTransactionHandle)MemoryTransactionHandle.INSTANCE, TestingConnectorSession.SESSION, TestMemoryPagesStore.createMemoryInsertTableHandle(tableId, activeTableIds));
        pageSink.appendPage(page);
        pageSink.finish();
    }

    private void createTable(long tableId, Long ... activeTableIds) {
        ConnectorPageSink pageSink = this.pageSinkProvider.createPageSink((ConnectorTransactionHandle)MemoryTransactionHandle.INSTANCE, TestingConnectorSession.SESSION, TestMemoryPagesStore.createMemoryOutputTableHandle(tableId, activeTableIds));
        pageSink.finish();
    }

    private static ConnectorOutputTableHandle createMemoryOutputTableHandle(long tableId, Long ... activeTableIds) {
        return new MemoryOutputTableHandle(tableId, (Set)ImmutableSet.copyOf((Object[])activeTableIds));
    }

    private static ConnectorInsertTableHandle createMemoryInsertTableHandle(long tableId, Long[] activeTableIds) {
        return new MemoryInsertTableHandle(tableId, (Set)ImmutableSet.copyOf((Object[])activeTableIds));
    }

    private static Page createPage() {
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(0);
        BigintType.BIGINT.writeLong(blockBuilder, 42L);
        return new Page(0, new Block[]{blockBuilder.build()});
    }

    private static Page createOneMegaBytePage() {
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(0);
        while (blockBuilder.getRetainedSizeInBytes() < 0x100000L) {
            BigintType.BIGINT.writeLong(blockBuilder, 42L);
        }
        return new Page(0, new Block[]{blockBuilder.build()});
    }
}

