/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import io.prestosql.Session;
import io.prestosql.execution.QueryStats;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.operator.OperatorStats;
import io.prestosql.plugin.memory.MemoryQueryRunner;
import io.prestosql.spi.QueryId;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.testing.AbstractTestQueryFramework;
import io.prestosql.testing.DistributedQueryRunner;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.MaterializedRow;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.ResultWithQueryId;
import io.prestosql.testing.assertions.Assert;
import io.prestosql.testng.services.Flaky;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestMemorySmoke
extends AbstractTestQueryFramework {
    private static final int LINEITEM_COUNT = 60175;
    private static final int ORDERS_COUNT = 15000;
    private static final int PART_COUNT = 2000;
    private static final int CUSTOMER_COUNT = 1500;

    protected QueryRunner createQueryRunner() throws Exception {
        return MemoryQueryRunner.createQueryRunner((Map<String, String>)ImmutableMap.of((Object)"dynamic-filtering.small-broadcast.max-distinct-values-per-driver", (Object)"100", (Object)"dynamic-filtering.small-broadcast.range-row-limit-per-driver", (Object)"100", (Object)"dynamic-filtering.large-broadcast.max-distinct-values-per-driver", (Object)"100", (Object)"dynamic-filtering.large-broadcast.range-row-limit-per-driver", (Object)"100000"));
    }

    @Test
    public void testCreateAndDropTable() {
        int tablesBeforeCreate = this.listMemoryTables().size();
        this.assertUpdate("CREATE TABLE test AS SELECT * FROM tpch.tiny.nation", "SELECT count(*) FROM nation");
        Assert.assertEquals((int)this.listMemoryTables().size(), (int)(tablesBeforeCreate + 1));
        this.assertUpdate("DROP TABLE test");
        Assert.assertEquals((int)this.listMemoryTables().size(), (int)tablesBeforeCreate);
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="line 1:1: Destination table 'memory.default.nation' already exists")
    public void testCreateTableWhenTableIsAlreadyCreated() {
        String createTableSql = "CREATE TABLE nation AS SELECT * FROM tpch.tiny.nation";
        this.assertUpdate(createTableSql);
    }

    @Test
    public void testSelect() {
        this.assertUpdate("CREATE TABLE test_select AS SELECT * FROM tpch.tiny.nation", "SELECT count(*) FROM nation");
        this.assertQuery("SELECT * FROM test_select ORDER BY nationkey", "SELECT * FROM nation ORDER BY nationkey");
        this.assertQueryResult("INSERT INTO test_select SELECT * FROM tpch.tiny.nation", 25L);
        this.assertQueryResult("INSERT INTO test_select SELECT * FROM tpch.tiny.nation", 25L);
        this.assertQueryResult("SELECT count(*) FROM test_select", 75L);
    }

    @Test
    public void testJoinDynamicFilteringNone() {
        this.assertDynamicFiltering("SELECT * FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.totalprice < 0", this.withBroadcastJoin(), 0, 0, 15000);
    }

    @Test
    public void testJoinLargeBuildSideDynamicFiltering() {
        String sql = "SELECT * FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey and orders.custkey BETWEEN 300 AND 700";
        int expectedRowCount = 15793;
        this.assertDynamicFiltering(sql, this.withBroadcastJoin(), expectedRowCount, 60175, 15000);
        this.assertDynamicFiltering(sql, this.withLargeDynamicFilters(), expectedRowCount, 60139, 15000);
    }

    @Test
    public void testPartitionedJoinNoDynamicFiltering() {
        this.assertDynamicFiltering("SELECT * FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.totalprice < 0", this.withPartitionedJoin(), 0, 60175, 15000);
    }

    @Test
    public void testJoinDynamicFilteringSingleValue() {
        this.assertQueryResult("SELECT orderkey FROM orders WHERE comment = 'nstructions sleep furiously among '", 1L);
        this.assertQueryResult("SELECT COUNT() FROM lineitem WHERE orderkey = 1", 6L);
        this.assertQueryResult("SELECT partkey FROM part WHERE comment = 'onic deposits'", 1552L);
        this.assertQueryResult("SELECT COUNT() FROM lineitem WHERE partkey = 1552", 39L);
        this.assertDynamicFiltering("SELECT * FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.comment = 'nstructions sleep furiously among '", this.withBroadcastJoin(), 6, 6, 15000);
        this.assertDynamicFiltering("SELECT l.comment FROM  lineitem l, part p WHERE p.partkey = l.partkey AND p.comment = 'onic deposits'", this.withBroadcastJoin(), 39, 39, 2000);
    }

    @Test
    public void testJoinDynamicFilteringImplicitCoercion() {
        this.assertUpdate("CREATE TABLE coerce_test AS SELECT CAST(orderkey as INT) orderkey_int FROM tpch.tiny.lineitem", "SELECT count(*) FROM lineitem");
        this.assertDynamicFiltering("SELECT * FROM coerce_test l JOIN orders o ON l.orderkey_int = o.orderkey AND o.comment = 'nstructions sleep furiously among '", this.withBroadcastJoin(), 6, 6, 15000);
    }

    @Test
    public void testJoinDynamicFilteringBlockProbeSide() {
        this.assertDynamicFiltering("SELECT l.comment FROM  lineitem l, part p, orders o WHERE l.orderkey = o.orderkey AND o.comment = 'nstructions sleep furiously among ' AND p.partkey = l.partkey AND p.comment = 'onic deposits'", this.withBroadcastJoinNonReordering(), 1, 1, 2000, 15000);
    }

    @Test
    public void testSemiJoinDynamicFilteringNone() {
        this.assertDynamicFiltering("SELECT * FROM lineitem WHERE lineitem.orderkey IN (SELECT orders.orderkey FROM orders WHERE orders.totalprice < 0)", this.withBroadcastJoin(), 0, 0, 15000);
    }

    @Test
    public void testSemiJoinLargeBuildSideDynamicFiltering() {
        String sql = "SELECT * FROM lineitem WHERE lineitem.orderkey IN (SELECT orders.orderkey FROM orders WHERE orders.custkey BETWEEN 300 AND 700)";
        int expectedRowCount = 15793;
        this.assertDynamicFiltering(sql, this.withBroadcastJoin(), expectedRowCount, 60175, 15000);
        this.assertDynamicFiltering(sql, this.withLargeDynamicFilters(), expectedRowCount, 60139, 15000);
    }

    @Test
    public void testPartitionedSemiJoinNoDynamicFiltering() {
        this.assertDynamicFiltering("SELECT * FROM lineitem WHERE lineitem.orderkey IN (SELECT orders.orderkey FROM orders WHERE orders.totalprice < 0)", this.withPartitionedJoin(), 0, 60175, 15000);
    }

    @Test
    public void testSemiJoinDynamicFilteringSingleValue() {
        this.assertDynamicFiltering("SELECT * FROM lineitem WHERE lineitem.orderkey IN (SELECT orders.orderkey FROM orders WHERE orders.comment = 'nstructions sleep furiously among ')", this.withBroadcastJoin(), 6, 6, 15000);
        this.assertDynamicFiltering("SELECT l.comment FROM lineitem l WHERE l.partkey IN (SELECT p.partkey FROM part p WHERE p.comment = 'onic deposits')", this.withBroadcastJoin(), 39, 39, 2000);
    }

    @Test
    public void testSemiJoinDynamicFilteringBlockProbeSide() {
        this.assertDynamicFiltering("SELECT t.comment FROM (SELECT * FROM lineitem l WHERE l.orderkey IN (SELECT o.orderkey FROM orders o WHERE o.comment = 'nstructions sleep furiously among ')) t WHERE t.partkey IN (SELECT p.partkey FROM part p WHERE p.comment = 'onic deposits')", this.withBroadcastJoinNonReordering(), 1, 1, 15000, 2000);
    }

    @Test
    @Flaky(issue="https://github.com/prestosql/presto/issues/5172", match="Lists differ at element")
    public void testCrossJoinDynamicFiltering() {
        this.assertUpdate("DROP TABLE IF EXISTS probe");
        this.assertUpdate("CREATE TABLE probe (k VARCHAR, v INTEGER)");
        this.assertUpdate("INSERT INTO probe VALUES ('a', 0), ('b', 1), ('c', 2), ('d', 3), ('e', NULL)", 5L);
        this.assertUpdate("DROP TABLE IF EXISTS build");
        this.assertUpdate("CREATE TABLE build (vmin INTEGER, vmax INTEGER)");
        this.assertUpdate("INSERT INTO build VALUES (1, 2), (NULL, NULL)", 2L);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v >= vmin", this.withBroadcastJoin(), 3, 3, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v > vmin", this.withBroadcastJoin(), 2, 2, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v <= vmax", this.withBroadcastJoin(), 3, 3, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v < vmax", this.withBroadcastJoin(), 2, 2, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v >= vmin AND v < vmax", this.withBroadcastJoin(), 1, 1, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v > vmin AND v <= vmax", this.withBroadcastJoin(), 1, 1, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v > vmin AND v < vmax", this.withBroadcastJoin(), 0, 0, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v > vmin AND vmax < 0", this.withBroadcastJoin(), 0, 0, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v BETWEEN vmin AND vmax", this.withBroadcastJoin(), 2, 2, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v >= vmin AND v <= vmax", this.withBroadcastJoin(), 2, 2, 2);
        this.assertDynamicFiltering("SELECT * FROM probe, build WHERE v BETWEEN vmin AND vmax", this.withBroadcastJoin(), 2, 2, 2);
        this.assertDynamicFiltering("SELECT * FROM probe, build WHERE v >= vmin AND v <= vmax", this.withBroadcastJoin(), 2, 2, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v BETWEEN vmin AND vmax - 1", this.withBroadcastJoin(), 1, 3, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v BETWEEN vmin + 1 AND vmax", this.withBroadcastJoin(), 1, 3, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v BETWEEN vmin + 1 AND vmax - 1", this.withBroadcastJoin(), 0, 5, 2);
        this.assertDynamicFiltering("SELECT * FROM probe, build WHERE v BETWEEN vmin AND vmax - 1", this.withBroadcastJoin(), 1, 3, 2);
        this.assertDynamicFiltering("SELECT * FROM probe, build WHERE v BETWEEN vmin + 1 AND vmax", this.withBroadcastJoin(), 1, 3, 2);
        this.assertDynamicFiltering("SELECT * FROM probe, build WHERE v BETWEEN vmin + 1 AND vmax - 1", this.withBroadcastJoin(), 0, 5, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v >= vmin AND v <= vmax - 1", this.withBroadcastJoin(), 1, 1, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v >= vmin + 1 AND v <= vmax", this.withBroadcastJoin(), 1, 1, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v >= vmin + 1 AND v <= vmax - 1", this.withBroadcastJoin(), 0, 0, 2);
        this.assertDynamicFiltering("SELECT * FROM probe, build WHERE v >= vmin AND v <= vmax - 1", this.withBroadcastJoin(), 1, 3, 2);
        this.assertDynamicFiltering("SELECT * FROM probe, build WHERE v >= vmin + 1 AND v <= vmax", this.withBroadcastJoin(), 1, 3, 2);
        this.assertDynamicFiltering("SELECT * FROM probe, build WHERE v >= vmin + 1 AND v <= vmax - 1", this.withBroadcastJoin(), 0, 5, 2);
        this.assertDynamicFiltering("SELECT * FROM probe WHERE v <= (SELECT max(vmax) FROM build)", this.withBroadcastJoin(), 3, 3, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v IS NOT DISTINCT FROM vmin", this.withBroadcastJoin(), 2, 2, 2);
    }

    @Test
    public void testIsNotDistinctFromNaN() {
        this.assertUpdate("DROP TABLE IF EXISTS probe_nan");
        this.assertUpdate("CREATE TABLE probe_nan (v DOUBLE)");
        this.assertUpdate("INSERT INTO probe_nan VALUES 0, 1, 2, NULL, nan()", 5L);
        this.assertUpdate("DROP TABLE IF EXISTS build_nan");
        this.assertUpdate("CREATE TABLE build_nan (v DOUBLE)");
        this.assertUpdate("INSERT INTO build_nan VALUES 1, NULL, nan()", 3L);
        this.assertDynamicFiltering("SELECT * FROM probe_nan p JOIN build_nan b ON p.v IS NOT DISTINCT FROM b.v", this.withBroadcastJoin(), 3, 5, 3);
        this.assertDynamicFiltering("SELECT * FROM probe_nan p JOIN build_nan b ON p.v = b.v", this.withBroadcastJoin(), 1, 1, 3);
    }

    @Test
    public void testCrossJoinLargeBuildSideDynamicFiltering() {
        this.assertDynamicFiltering("SELECT * FROM orders o, customer c WHERE o.custkey < c.custkey AND c.name < 'Customer#000001000' AND o.custkey > 1000", this.withBroadcastJoin(), 0, 15000, 1500);
    }

    private void assertDynamicFiltering(@Language(value="SQL") String selectQuery, Session session, int expectedRowCount, int ... expectedOperatorRowsRead) {
        ResultWithQueryId result = this.getDistributedQueryRunner().executeWithQueryId(session, selectQuery);
        Assert.assertEquals((int)((MaterializedResult)result.getResult()).getRowCount(), (int)expectedRowCount);
        Assert.assertEquals(TestMemorySmoke.getOperatorRowsRead(this.getDistributedQueryRunner(), result.getQueryId()), (Collection)Ints.asList((int[])expectedOperatorRowsRead));
    }

    private Session withBroadcastJoin() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).build();
    }

    private Session withLargeDynamicFilters() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("enable_large_dynamic_filters", "true").build();
    }

    private Session withBroadcastJoinNonReordering() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.NONE.name()).build();
    }

    private Session withPartitionedJoin() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).build();
    }

    private static List<Integer> getOperatorRowsRead(DistributedQueryRunner runner, QueryId queryId) {
        QueryStats stats = runner.getCoordinator().getQueryManager().getFullQueryInfo(queryId).getQueryStats();
        return (List)stats.getOperatorSummaries().stream().filter(summary -> summary.getOperatorType().contains("Scan")).map(OperatorStats::getInputPositions).map(Math::toIntExact).collect(ImmutableList.toImmutableList());
    }

    @Test
    public void testJoinDynamicFilteringMultiJoin() {
        this.assertUpdate("CREATE TABLE t0 (k0 integer, v0 real)");
        this.assertUpdate("CREATE TABLE t1 (k1 integer, v1 real)");
        this.assertUpdate("CREATE TABLE t2 (k2 integer, v2 real)");
        this.assertUpdate("INSERT INTO t0 VALUES (1, 1.0)", 1L);
        this.assertUpdate("INSERT INTO t1 VALUES (1, 2.0)", 1L);
        this.assertUpdate("INSERT INTO t2 VALUES (1, 3.0)", 1L);
        String query = "SELECT k0, k1, k2 FROM t0, t1, t2 WHERE (k0 = k1) AND (k0 = k2) AND (v0 + v1 = v2)";
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.NONE.name()).build();
        this.assertQuery(session, query, "SELECT 1, 1, 1");
    }

    @Test
    public void testCreateTableWithNoData() {
        this.assertUpdate("CREATE TABLE test_empty (a BIGINT)");
        this.assertQueryResult("SELECT count(*) FROM test_empty", 0L);
        this.assertQueryResult("INSERT INTO test_empty SELECT nationkey FROM tpch.tiny.nation", 25L);
        this.assertQueryResult("SELECT count(*) FROM test_empty", 25L);
    }

    @Test
    public void testCreateFilteredOutTable() {
        this.assertUpdate("CREATE TABLE filtered_out AS SELECT nationkey FROM tpch.tiny.nation WHERE nationkey < 0", "SELECT count(nationkey) FROM nation WHERE nationkey < 0");
        this.assertQueryResult("SELECT count(*) FROM filtered_out", 0L);
        this.assertQueryResult("INSERT INTO filtered_out SELECT nationkey FROM tpch.tiny.nation", 25L);
        this.assertQueryResult("SELECT count(*) FROM filtered_out", 25L);
    }

    @Test
    public void testSelectFromEmptyTable() {
        this.assertUpdate("CREATE TABLE test_select_empty AS SELECT * FROM tpch.tiny.nation WHERE nationkey > 1000", "SELECT count(*) FROM nation WHERE nationkey > 1000");
        this.assertQueryResult("SELECT count(*) FROM test_select_empty", 0L);
    }

    @Test
    public void testSelectSingleRow() {
        this.assertQuery("SELECT * FROM tpch.tiny.nation WHERE nationkey = 1", "SELECT * FROM nation WHERE nationkey = 1");
    }

    @Test
    public void testSelectColumnsSubset() {
        this.assertQuery("SELECT nationkey, regionkey FROM tpch.tiny.nation ORDER BY nationkey", "SELECT nationkey, regionkey FROM nation ORDER BY nationkey");
    }

    @Test
    public void testCreateSchema() {
        this.assertQueryFails("DROP SCHEMA schema1", "line 1:1: Schema 'memory.schema1' does not exist");
        this.assertUpdate("CREATE SCHEMA schema1");
        this.assertQueryFails("CREATE SCHEMA schema1", "line 1:1: Schema 'memory.schema1' already exists");
        this.assertUpdate("CREATE TABLE schema1.x(t int)");
        this.assertQueryFails("DROP SCHEMA schema1", "Schema not empty: schema1");
        this.assertUpdate("DROP TABLE schema1.x");
        this.assertUpdate("DROP SCHEMA schema1");
        this.assertQueryFails("DROP SCHEMA schema1", "line 1:1: Schema 'memory.schema1' does not exist");
        this.assertUpdate("DROP SCHEMA IF EXISTS schema1");
    }

    @Test
    public void testCreateTableInNonDefaultSchema() {
        this.assertUpdate("CREATE SCHEMA schema1");
        this.assertUpdate("CREATE SCHEMA schema2");
        this.assertQueryResult("SHOW SCHEMAS", "default", "information_schema", "schema1", "schema2");
        this.assertUpdate("CREATE TABLE schema1.nation AS SELECT * FROM tpch.tiny.nation WHERE nationkey % 2 = 0", "SELECT count(*) FROM nation WHERE MOD(nationkey, 2) = 0");
        this.assertUpdate("CREATE TABLE schema2.nation AS SELECT * FROM tpch.tiny.nation WHERE nationkey % 2 = 1", "SELECT count(*) FROM nation WHERE MOD(nationkey, 2) = 1");
        this.assertQueryResult("SELECT count(*) FROM schema1.nation", 13L);
        this.assertQueryResult("SELECT count(*) FROM schema2.nation", 12L);
    }

    @Test
    public void testCreateTableAndViewInNotExistSchema() {
        int tablesBeforeCreate = this.listMemoryTables().size();
        this.assertQueryFails("CREATE TABLE schema3.test_table3 (x date)", "Schema schema3 not found");
        this.assertQueryFails("CREATE VIEW schema4.test_view4 AS SELECT 123 x", "Schema schema4 not found");
        this.assertQueryFails("CREATE OR REPLACE VIEW schema5.test_view5 AS SELECT 123 x", "Schema schema5 not found");
        int tablesAfterCreate = this.listMemoryTables().size();
        Assert.assertEquals((int)tablesBeforeCreate, (int)tablesAfterCreate);
    }

    @Test
    public void testRenameTable() {
        this.assertUpdate("CREATE TABLE test_table_to_be_renamed (a BIGINT)");
        this.assertQueryFails("ALTER TABLE test_table_to_be_renamed RENAME TO memory.test_schema_not_exist.test_table_renamed", "Schema test_schema_not_exist not found");
        this.assertUpdate("ALTER TABLE test_table_to_be_renamed RENAME TO test_table_renamed");
        this.assertQueryResult("SELECT count(*) FROM test_table_renamed", 0L);
        this.assertUpdate("CREATE SCHEMA test_different_schema");
        this.assertUpdate("ALTER TABLE test_table_renamed RENAME TO test_different_schema.test_table_renamed");
        this.assertQueryResult("SELECT count(*) FROM test_different_schema.test_table_renamed", 0L);
        this.assertUpdate("DROP TABLE test_different_schema.test_table_renamed");
        this.assertUpdate("DROP SCHEMA test_different_schema");
    }

    @Test
    public void testViews() {
        String query = "SELECT orderkey, orderstatus, totalprice / 2 half FROM orders";
        this.assertUpdate("CREATE VIEW test_view AS SELECT 123 x");
        this.assertUpdate("CREATE OR REPLACE VIEW test_view AS " + query);
        this.assertQueryFails("CREATE TABLE test_view (x date)", "View \\[default.test_view] already exists");
        this.assertQueryFails("CREATE VIEW test_view AS SELECT 123 x", "View already exists: default.test_view");
        this.assertQuery("SELECT * FROM test_view", query);
        org.testng.Assert.assertTrue((boolean)this.computeActual("SHOW TABLES").getOnlyColumnAsSet().contains("test_view"));
        this.assertUpdate("DROP VIEW test_view");
        this.assertQueryFails("DROP VIEW test_view", "line 1:1: View 'memory.default.test_view' does not exist");
    }

    @Test
    public void testRenameView() {
        String query = "SELECT orderkey, orderstatus, totalprice / 2 half FROM orders";
        this.assertUpdate("CREATE VIEW test_view_to_be_renamed AS " + query);
        this.assertQueryFails("ALTER VIEW test_view_to_be_renamed RENAME TO memory.test_schema_not_exist.test_view_renamed", "Schema test_schema_not_exist not found");
        this.assertUpdate("ALTER VIEW test_view_to_be_renamed RENAME TO test_view_renamed");
        this.assertQuery("SELECT * FROM test_view_renamed", query);
        this.assertUpdate("CREATE SCHEMA test_different_schema");
        this.assertUpdate("ALTER VIEW test_view_renamed RENAME TO test_different_schema.test_view_renamed");
        this.assertQuery("SELECT * FROM test_different_schema.test_view_renamed", query);
        this.assertUpdate("DROP VIEW test_different_schema.test_view_renamed");
        this.assertUpdate("DROP SCHEMA test_different_schema");
    }

    private List<QualifiedObjectName> listMemoryTables() {
        return this.getQueryRunner().listTables(this.getSession(), "memory", "default");
    }

    private void assertQueryResult(@Language(value="SQL") String sql, Object ... expected) {
        MaterializedResult rows = this.computeActual(sql);
        Assert.assertEquals((int)rows.getRowCount(), (int)expected.length);
        for (int i = 0; i < expected.length; ++i) {
            MaterializedRow materializedRow = (MaterializedRow)rows.getMaterializedRows().get(i);
            int fieldCount = materializedRow.getFieldCount();
            Assert.assertEquals((int)fieldCount, (int)1, (String)String.format("Expected only one column, but got '%d'", fieldCount));
            Object value = materializedRow.getField(0);
            Assert.assertEquals((Object)value, (Object)expected[i]);
            Assert.assertEquals((int)materializedRow.getFieldCount(), (int)1);
        }
    }
}

