/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.memory;

import io.airlift.testing.Assertions;
import io.airlift.units.Duration;
import io.prestosql.plugin.memory.MemoryQueryRunner;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.testing.AbstractTestQueryFramework;
import io.prestosql.testing.QueryRunner;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestMemoryWorkerCrash
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return MemoryQueryRunner.createQueryRunner();
    }

    @Test
    public void tableAccessAfterWorkerCrash() throws Exception {
        this.getQueryRunner().execute("CREATE TABLE test_nation as SELECT * FROM nation");
        this.assertQuery("SELECT * FROM test_nation ORDER BY nationkey", "SELECT * FROM nation ORDER BY nationkey");
        this.closeWorker();
        this.assertQueryFails("SELECT * FROM test_nation ORDER BY nationkey", "No nodes available to run query");
        this.getQueryRunner().execute("INSERT INTO test_nation SELECT * FROM tpch.tiny.nation");
        this.assertQueryFails("SELECT * FROM test_nation ORDER BY nationkey", "No nodes available to run query");
        this.getQueryRunner().execute("CREATE TABLE test_region as SELECT * FROM tpch.tiny.region");
        this.assertQuery("SELECT * FROM test_region ORDER BY regionkey", "SELECT * FROM region ORDER BY regionkey");
    }

    private void closeWorker() throws Exception {
        int nodeCount = this.getNodeCount();
        TestingPrestoServer worker = this.getDistributedQueryRunner().getServers().stream().filter(server -> !server.isCoordinator()).findAny().orElseThrow(() -> new IllegalStateException("No worker nodes"));
        worker.close();
        this.waitForNodes(nodeCount - 1);
    }

    private void waitForNodes(int numberOfNodes) throws InterruptedException {
        long start = System.nanoTime();
        while (this.getDistributedQueryRunner().getCoordinator().refreshNodes().getActiveNodes().size() < numberOfNodes) {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(10.0, TimeUnit.SECONDS));
            TimeUnit.MILLISECONDS.sleep(10L);
        }
    }
}

