/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.metadata;

import io.prestosql.orc.metadata.OrcColumnId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class ColumnMetadata<T> {
    private final List<T> metadata;

    public ColumnMetadata(List<T> metadata) {
        this.metadata = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(metadata, "metadata is null")));
    }

    public T get(OrcColumnId columnId) {
        return this.metadata.get(columnId.getId());
    }

    public int size() {
        return this.metadata.size();
    }

    public String toString() {
        return this.metadata.toString();
    }

    public Stream<T> stream() {
        return this.metadata.stream();
    }
}

