/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.stream;

import io.airlift.slice.Slice;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.OrcDecompressor;
import io.prestosql.orc.stream.CompressedOrcChunkLoader;
import io.prestosql.orc.stream.MemoryOrcDataReader;
import io.prestosql.orc.stream.OrcDataReader;
import io.prestosql.orc.stream.UncompressedOrcChunkLoader;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

public interface OrcChunkLoader {
    public static OrcChunkLoader create(OrcDataSourceId orcDataSourceId, Slice chunk, Optional<OrcDecompressor> decompressor, AggregatedMemoryContext systemMemoryContext) {
        return OrcChunkLoader.create(new MemoryOrcDataReader(orcDataSourceId, chunk, chunk.length()), decompressor, systemMemoryContext);
    }

    public static OrcChunkLoader create(OrcDataReader dataReader, Optional<OrcDecompressor> decompressor, AggregatedMemoryContext memoryContext) {
        Objects.requireNonNull(dataReader, "dataReader is null");
        Objects.requireNonNull(decompressor, "decompressor is null");
        Objects.requireNonNull(memoryContext, "memoryContext is null");
        if (decompressor.isPresent()) {
            return new CompressedOrcChunkLoader(dataReader, decompressor.get(), memoryContext);
        }
        return new UncompressedOrcChunkLoader(dataReader, memoryContext);
    }

    public OrcDataSourceId getOrcDataSourceId();

    public boolean hasNextChunk();

    public Slice nextChunk() throws IOException;

    public long getLastCheckpoint();

    public void seekToCheckpoint(long var1) throws IOException;
}

