/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.reader;

import io.prestosql.parquet.DataPage;
import io.prestosql.parquet.DataPageV1;
import io.prestosql.parquet.DataPageV2;
import io.prestosql.parquet.DictionaryPage;
import io.prestosql.parquet.ParquetCompressionUtils;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

class PageReader {
    private final CompressionCodecName codec;
    private final long valueCount;
    private final List<DataPage> compressedPages;
    private final DictionaryPage compressedDictionaryPage;

    public PageReader(CompressionCodecName codec, List<DataPage> compressedPages, DictionaryPage compressedDictionaryPage) {
        this.codec = codec;
        this.compressedPages = new LinkedList<DataPage>(compressedPages);
        this.compressedDictionaryPage = compressedDictionaryPage;
        int count = 0;
        for (DataPage page : compressedPages) {
            count += page.getValueCount();
        }
        this.valueCount = count;
    }

    public long getTotalValueCount() {
        return this.valueCount;
    }

    public DataPage readPage() {
        if (this.compressedPages.isEmpty()) {
            return null;
        }
        DataPage compressedPage = this.compressedPages.remove(0);
        try {
            if (compressedPage instanceof DataPageV1) {
                DataPageV1 dataPageV1 = (DataPageV1)compressedPage;
                return new DataPageV1(ParquetCompressionUtils.decompress(this.codec, dataPageV1.getSlice(), dataPageV1.getUncompressedSize()), dataPageV1.getValueCount(), dataPageV1.getUncompressedSize(), dataPageV1.getRepetitionLevelEncoding(), dataPageV1.getDefinitionLevelEncoding(), dataPageV1.getValueEncoding());
            }
            DataPageV2 dataPageV2 = (DataPageV2)compressedPage;
            if (!dataPageV2.isCompressed()) {
                return dataPageV2;
            }
            int uncompressedSize = dataPageV2.getUncompressedSize() - dataPageV2.getDefinitionLevels().length() - dataPageV2.getRepetitionLevels().length();
            return new DataPageV2(dataPageV2.getRowCount(), dataPageV2.getNullCount(), dataPageV2.getValueCount(), dataPageV2.getRepetitionLevels(), dataPageV2.getDefinitionLevels(), dataPageV2.getDataEncoding(), ParquetCompressionUtils.decompress(this.codec, dataPageV2.getSlice(), uncompressedSize), dataPageV2.getUncompressedSize(), dataPageV2.getStatistics(), false);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not decompress page", e);
        }
    }

    public DictionaryPage readDictionaryPage() {
        if (this.compressedDictionaryPage == null) {
            return null;
        }
        try {
            return new DictionaryPage(ParquetCompressionUtils.decompress(this.codec, this.compressedDictionaryPage.getSlice(), this.compressedDictionaryPage.getUncompressedSize()), this.compressedDictionaryPage.getDictionarySize(), this.compressedDictionaryPage.getEncoding());
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading dictionary page", e);
        }
    }
}

