/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.writer;

import com.google.common.collect.ImmutableList;
import io.prestosql.parquet.writer.ArrayColumnWriter;
import io.prestosql.parquet.writer.ColumnWriter;
import io.prestosql.parquet.writer.MapColumnWriter;
import io.prestosql.parquet.writer.ParquetTypeVisitor;
import io.prestosql.parquet.writer.PrimitiveColumnWriter;
import io.prestosql.parquet.writer.StructColumnWriter;
import io.prestosql.parquet.writer.valuewriter.BigintValueWriter;
import io.prestosql.parquet.writer.valuewriter.BooleanValueWriter;
import io.prestosql.parquet.writer.valuewriter.CharValueWriter;
import io.prestosql.parquet.writer.valuewriter.DateValueWriter;
import io.prestosql.parquet.writer.valuewriter.DecimalValueWriter;
import io.prestosql.parquet.writer.valuewriter.DoubleValueWriter;
import io.prestosql.parquet.writer.valuewriter.IntegerValueWriter;
import io.prestosql.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.prestosql.parquet.writer.valuewriter.RealValueWriter;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

class ParquetWriters {
    private ParquetWriters() {
    }

    static List<ColumnWriter> getColumnWriters(MessageType messageType, Map<List<String>, Type> prestoTypes, ParquetProperties parquetProperties, CompressionCodecName compressionCodecName) {
        WriteBuilder writeBuilder = new WriteBuilder(messageType, prestoTypes, parquetProperties, compressionCodecName);
        ParquetTypeVisitor.visit((org.apache.parquet.schema.Type)messageType, writeBuilder);
        return writeBuilder.build();
    }

    private static PrimitiveValueWriter getValueWriter(ValuesWriter valuesWriter, Type type, PrimitiveType parquetType) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return new BooleanValueWriter(valuesWriter, parquetType);
        }
        if (IntegerType.INTEGER.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || TinyintType.TINYINT.equals((Object)type)) {
            return new IntegerValueWriter(valuesWriter, type, parquetType);
        }
        if (type instanceof DecimalType) {
            return new DecimalValueWriter(valuesWriter, type, parquetType);
        }
        if (DateType.DATE.equals((Object)type)) {
            return new DateValueWriter(valuesWriter, parquetType);
        }
        if (BigintType.BIGINT.equals((Object)type) || TimestampType.TIMESTAMP.equals((Object)type)) {
            return new BigintValueWriter(valuesWriter, type, parquetType);
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return new DoubleValueWriter(valuesWriter, parquetType);
        }
        if (RealType.REAL.equals((Object)type)) {
            return new RealValueWriter(valuesWriter, parquetType);
        }
        if (type instanceof VarcharType || type instanceof CharType || type instanceof VarbinaryType) {
            return new CharValueWriter(valuesWriter, type, parquetType);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported type in parquet writer: %s", type));
    }

    private static class WriteBuilder
    extends ParquetTypeVisitor<ColumnWriter> {
        private final MessageType type;
        private final Map<List<String>, Type> prestoTypes;
        private final ParquetProperties parquetProperties;
        private final CompressionCodecName compressionCodecName;
        private final ImmutableList.Builder<ColumnWriter> builder = ImmutableList.builder();

        WriteBuilder(MessageType messageType, Map<List<String>, Type> prestoTypes, ParquetProperties parquetProperties, CompressionCodecName compressionCodecName) {
            this.type = Objects.requireNonNull(messageType, "messageType is null");
            this.prestoTypes = Objects.requireNonNull(prestoTypes, "prestoTypes is null");
            this.parquetProperties = Objects.requireNonNull(parquetProperties, "parquetProperties is null");
            this.compressionCodecName = Objects.requireNonNull(compressionCodecName, "compressionCodecName is null");
        }

        List<ColumnWriter> build() {
            return this.builder.build();
        }

        @Override
        public ColumnWriter message(MessageType message, List<ColumnWriter> fields) {
            this.builder.addAll(fields);
            return super.message(message, fields);
        }

        @Override
        public ColumnWriter struct(GroupType struct, List<ColumnWriter> fields) {
            String[] path = this.currentPath();
            int fieldDefinitionLevel = this.type.getMaxDefinitionLevel(path);
            int fieldRepetitionLevel = this.type.getMaxRepetitionLevel(path);
            return new StructColumnWriter((List<ColumnWriter>)ImmutableList.copyOf(fields), fieldDefinitionLevel, fieldRepetitionLevel);
        }

        @Override
        public ColumnWriter list(GroupType array, ColumnWriter element) {
            String[] path = this.currentPath();
            int fieldDefinitionLevel = this.type.getMaxDefinitionLevel(path);
            int fieldRepetitionLevel = this.type.getMaxRepetitionLevel(path);
            return new ArrayColumnWriter(element, fieldDefinitionLevel, fieldRepetitionLevel);
        }

        @Override
        public ColumnWriter map(GroupType map, ColumnWriter key, ColumnWriter value) {
            String[] path = this.currentPath();
            int fieldDefinitionLevel = this.type.getMaxDefinitionLevel(path);
            int fieldRepetitionLevel = this.type.getMaxRepetitionLevel(path);
            return new MapColumnWriter(key, value, fieldDefinitionLevel, fieldRepetitionLevel);
        }

        @Override
        public ColumnWriter primitive(PrimitiveType primitive) {
            Object[] path = this.currentPath();
            int fieldDefinitionLevel = this.type.getMaxDefinitionLevel((String[])path);
            int fieldRepetitionLevel = this.type.getMaxRepetitionLevel((String[])path);
            ColumnDescriptor columnDescriptor = new ColumnDescriptor((String[])path, primitive, fieldRepetitionLevel, fieldDefinitionLevel);
            Type prestoType = Objects.requireNonNull(this.prestoTypes.get(ImmutableList.copyOf((Object[])path)), " presto type is null");
            return new PrimitiveColumnWriter(prestoType, columnDescriptor, ParquetWriters.getValueWriter(this.parquetProperties.newValuesWriter(columnDescriptor), prestoType, columnDescriptor.getPrimitiveType()), this.parquetProperties.newDefinitionLevelEncoder(columnDescriptor), this.parquetProperties.newRepetitionLevelEncoder(columnDescriptor), this.compressionCodecName, this.parquetProperties.getPageSizeThreshold());
        }

        private String[] currentPath() {
            String[] path = new String[this.fieldNames.size()];
            if (!this.fieldNames.isEmpty()) {
                Iterator iter = this.fieldNames.descendingIterator();
                int i = 0;
                while (iter.hasNext()) {
                    path[i] = (String)iter.next();
                    ++i;
                }
            }
            return path;
        }
    }
}

