/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import io.prestosql.plugin.base.type.DecodedTimestamp;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import org.apache.parquet.io.api.Binary;

public final class ParquetTimestampUtils {
    @VisibleForTesting
    static final int JULIAN_EPOCH_OFFSET_DAYS = 2440588;

    private ParquetTimestampUtils() {
    }

    public static DecodedTimestamp decode(Binary timestampBinary) {
        if (timestampBinary.length() != 12) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Parquet timestamp must be 12 bytes, actual " + timestampBinary.length());
        }
        byte[] bytes = timestampBinary.getBytes();
        long timeOfDayNanos = Longs.fromBytes((byte)bytes[7], (byte)bytes[6], (byte)bytes[5], (byte)bytes[4], (byte)bytes[3], (byte)bytes[2], (byte)bytes[1], (byte)bytes[0]);
        Verify.verify((timeOfDayNanos >= 0L && timeOfDayNanos < 86400000000000L ? 1 : 0) != 0, (String)"Invalid timeOfDayNanos: %s", (long)timeOfDayNanos);
        int julianDay = Ints.fromBytes((byte)bytes[11], (byte)bytes[10], (byte)bytes[9], (byte)bytes[8]);
        long epochSeconds = (long)(julianDay - 2440588) * 86400L + timeOfDayNanos / 1000000000L;
        return new DecodedTimestamp(epochSeconds, (int)(timeOfDayNanos % 1000000000L));
    }
}

