/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.predicate;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.prestosql.parquet.DictionaryPage;
import io.prestosql.parquet.ParquetCompressionUtils;
import io.prestosql.parquet.ParquetCorruptionException;
import io.prestosql.parquet.ParquetDataSource;
import io.prestosql.parquet.ParquetEncoding;
import io.prestosql.parquet.ParquetTypeUtils;
import io.prestosql.parquet.RichColumnDescriptor;
import io.prestosql.parquet.predicate.DictionaryDescriptor;
import io.prestosql.parquet.predicate.ParquetIntegerStatistics;
import io.prestosql.parquet.predicate.Predicate;
import io.prestosql.parquet.predicate.TupleDomainParquetPredicate;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.DictionaryPageHeader;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.PageType;
import org.apache.parquet.format.Util;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.joda.time.DateTimeZone;

public final class PredicateUtils {
    private PredicateUtils() {
    }

    public static boolean isStatisticsOverflow(Type type, ParquetIntegerStatistics parquetIntegerStatistics) {
        long min = parquetIntegerStatistics.getMin();
        long max = parquetIntegerStatistics.getMax();
        if (type == TinyintType.TINYINT) {
            return min < -128L || max > 127L;
        }
        if (type == SmallintType.SMALLINT) {
            return min < -32768L || max > 32767L;
        }
        if (type == IntegerType.INTEGER) {
            return min < Integer.MIN_VALUE || max > Integer.MAX_VALUE;
        }
        if (type == BigintType.BIGINT) {
            return false;
        }
        if (type instanceof DecimalType && ((DecimalType)type).getScale() == 0) {
            DecimalType decimalType = (DecimalType)type;
            if (!decimalType.isShort()) {
                return false;
            }
            return BigDecimal.valueOf(min).compareTo(PredicateUtils.minimalValue(decimalType)) < 0 || BigDecimal.valueOf(max).compareTo(PredicateUtils.maximalValue(decimalType)) > 0;
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    private static BigDecimal minimalValue(DecimalType decimalType) {
        return new BigDecimal(String.format("-%s.%s", "9".repeat(decimalType.getPrecision() - decimalType.getScale()), "9".repeat(decimalType.getScale())));
    }

    private static BigDecimal maximalValue(DecimalType decimalType) {
        return new BigDecimal(String.format("+%s.%s", "9".repeat(decimalType.getPrecision() - decimalType.getScale()), "9".repeat(decimalType.getScale())));
    }

    public static Predicate buildPredicate(MessageType requestedSchema, TupleDomain<ColumnDescriptor> parquetTupleDomain, Map<List<String>, RichColumnDescriptor> descriptorsByPath, DateTimeZone timeZone) {
        ImmutableList.Builder columnReferences = ImmutableList.builder();
        for (String[] paths : requestedSchema.getPaths()) {
            RichColumnDescriptor descriptor = descriptorsByPath.get(Arrays.asList(paths));
            if (descriptor == null) continue;
            columnReferences.add((Object)descriptor);
        }
        return new TupleDomainParquetPredicate(parquetTupleDomain, (List<RichColumnDescriptor>)columnReferences.build(), timeZone);
    }

    public static boolean predicateMatches(Predicate parquetPredicate, BlockMetaData block, ParquetDataSource dataSource, Map<List<String>, RichColumnDescriptor> descriptorsByPath, TupleDomain<ColumnDescriptor> parquetTupleDomain) throws ParquetCorruptionException {
        Map<ColumnDescriptor, Statistics<?>> columnStatistics = PredicateUtils.getStatistics(block, descriptorsByPath);
        if (!parquetPredicate.matches(block.getRowCount(), columnStatistics, dataSource.getId())) {
            return false;
        }
        return PredicateUtils.dictionaryPredicatesMatch(parquetPredicate, block, dataSource, descriptorsByPath, parquetTupleDomain);
    }

    private static Map<ColumnDescriptor, Statistics<?>> getStatistics(BlockMetaData blockMetadata, Map<List<String>, RichColumnDescriptor> descriptorsByPath) {
        ImmutableMap.Builder statistics = ImmutableMap.builder();
        for (ColumnChunkMetaData columnMetaData : blockMetadata.getColumns()) {
            RichColumnDescriptor descriptor;
            Statistics columnStatistics = columnMetaData.getStatistics();
            if (columnStatistics == null || (descriptor = descriptorsByPath.get(Arrays.asList(columnMetaData.getPath().toArray()))) == null) continue;
            statistics.put((Object)descriptor, (Object)columnStatistics);
        }
        return statistics.build();
    }

    private static boolean dictionaryPredicatesMatch(Predicate parquetPredicate, BlockMetaData blockMetadata, ParquetDataSource dataSource, Map<List<String>, RichColumnDescriptor> descriptorsByPath, TupleDomain<ColumnDescriptor> parquetTupleDomain) {
        for (ColumnChunkMetaData columnMetaData : blockMetadata.getColumns()) {
            Slice buffer;
            RichColumnDescriptor descriptor = descriptorsByPath.get(Arrays.asList(columnMetaData.getPath().toArray()));
            if (descriptor == null || !PredicateUtils.isOnlyDictionaryEncodingPages(columnMetaData) || !PredicateUtils.isColumnPredicate(descriptor, parquetTupleDomain) || parquetPredicate.matches(new DictionaryDescriptor(descriptor, PredicateUtils.readDictionaryPage(buffer = dataSource.readFully(columnMetaData.getStartingPos(), Math.toIntExact(columnMetaData.getTotalSize())), columnMetaData.getCodec())))) continue;
            return false;
        }
        return true;
    }

    private static Optional<DictionaryPage> readDictionaryPage(Slice data, CompressionCodecName codecName) {
        try {
            BasicSliceInput inputStream = data.getInput();
            PageHeader pageHeader = Util.readPageHeader((InputStream)inputStream);
            if (pageHeader.type != PageType.DICTIONARY_PAGE) {
                return Optional.empty();
            }
            Slice compressedData = inputStream.readSlice(pageHeader.getCompressed_page_size());
            DictionaryPageHeader dicHeader = pageHeader.getDictionary_page_header();
            ParquetEncoding encoding = ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dicHeader.getEncoding().name()));
            int dictionarySize = dicHeader.getNum_values();
            return Optional.of(new DictionaryPage(ParquetCompressionUtils.decompress(codecName, compressedData, pageHeader.getUncompressed_page_size()), dictionarySize, encoding));
        }
        catch (IOException ignored) {
            return Optional.empty();
        }
    }

    private static boolean isColumnPredicate(ColumnDescriptor columnDescriptor, TupleDomain<ColumnDescriptor> parquetTupleDomain) {
        Verify.verify((boolean)parquetTupleDomain.getDomains().isPresent(), (String)"parquetTupleDomain is empty", (Object[])new Object[0]);
        return ((Map)parquetTupleDomain.getDomains().get()).containsKey(columnDescriptor);
    }

    @VisibleForTesting
    static boolean isOnlyDictionaryEncodingPages(ColumnChunkMetaData columnMetaData) {
        EncodingStats stats = columnMetaData.getEncodingStats();
        if (stats != null) {
            return stats.hasDictionaryPages() && !stats.hasNonDictionaryEncodedPages();
        }
        Set encodings = columnMetaData.getEncodings();
        if (encodings.contains(Encoding.PLAIN_DICTIONARY)) {
            return Sets.difference((Set)encodings, (Set)ImmutableSet.of((Object)Encoding.PLAIN_DICTIONARY, (Object)Encoding.RLE, (Object)Encoding.BIT_PACKED)).isEmpty();
        }
        return false;
    }
}

