/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.reader;

import io.prestosql.parquet.RichColumnDescriptor;
import io.prestosql.parquet.reader.PrimitiveColumnReader;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;

public class Int64TimestampMillisColumnReader
extends PrimitiveColumnReader {
    public Int64TimestampMillisColumnReader(RichColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            long utcMillis = this.valuesReader.readLong();
            if (type instanceof TimestampWithTimeZoneType) {
                type.writeLong(blockBuilder, DateTimeEncoding.packDateTimeWithZone((long)utcMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY));
            } else {
                type.writeLong(blockBuilder, utcMillis * 1000L);
            }
        } else if (this.isValueNull()) {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            this.valuesReader.readLong();
        }
    }
}

