/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.reader;

import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.parquet.ParquetDataSource;
import io.prestosql.parquet.ParquetValidationUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.apache.parquet.CorruptStatistics;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.ColumnChunk;
import org.apache.parquet.format.ColumnMetaData;
import org.apache.parquet.format.CompressionCodec;
import org.apache.parquet.format.ConvertedType;
import org.apache.parquet.format.Encoding;
import org.apache.parquet.format.KeyValue;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.format.Type;
import org.apache.parquet.format.Util;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.format.converter.ParquetMetadataConverterUtil;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public final class MetadataReader {
    private static final Slice MAGIC = Slices.utf8Slice((String)"PAR1");
    private static final int POST_SCRIPT_SIZE = 4 + MAGIC.length();
    private static final int EXPECTED_FOOTER_SIZE = 16384;
    private static final ParquetMetadataConverter PARQUET_METADATA_CONVERTER = new ParquetMetadataConverter();

    private MetadataReader() {
    }

    public static ParquetMetadata readFooter(ParquetDataSource dataSource) throws IOException {
        BasicSliceInput metadataStream;
        org.apache.parquet.format.FileMetaData fileMetaData;
        List schema;
        ParquetValidationUtils.validateParquet(dataSource.getEstimatedSize() >= (long)(MAGIC.length() + POST_SCRIPT_SIZE), "%s is not a valid Parquet File", dataSource.getId());
        long estimatedFileSize = dataSource.getEstimatedSize();
        long expectedReadSize = Math.min(estimatedFileSize, 16384L);
        Slice buffer = dataSource.readTail(Math.toIntExact(expectedReadSize));
        Slice magic = buffer.slice(buffer.length() - MAGIC.length(), MAGIC.length());
        ParquetValidationUtils.validateParquet(MAGIC.equals((Object)magic), "Not valid Parquet file: %s expected magic number: %s got: %s", dataSource.getId(), MAGIC.toStringUtf8(), magic.toStringUtf8());
        int metadataLength = buffer.getInt(buffer.length() - POST_SCRIPT_SIZE);
        long metadataIndex = estimatedFileSize - (long)POST_SCRIPT_SIZE - (long)metadataLength;
        ParquetValidationUtils.validateParquet(metadataIndex >= (long)MAGIC.length() && metadataIndex < estimatedFileSize - (long)POST_SCRIPT_SIZE, "Corrupted Parquet file: %s metadata index: %s out of range", dataSource.getId(), metadataIndex);
        int completeFooterSize = metadataLength + POST_SCRIPT_SIZE;
        if (completeFooterSize > buffer.length()) {
            buffer = dataSource.readTail(completeFooterSize);
        }
        ParquetValidationUtils.validateParquet(!(schema = (fileMetaData = Util.readFileMetaData((InputStream)(metadataStream = buffer.slice(buffer.length() - completeFooterSize, metadataLength).getInput()))).getSchema()).isEmpty(), "Empty Parquet schema in file: %s", dataSource.getId());
        MessageType messageType = MetadataReader.readParquetSchema(schema);
        ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
        List rowGroups = fileMetaData.getRow_groups();
        if (rowGroups != null) {
            for (RowGroup rowGroup : rowGroups) {
                BlockMetaData blockMetaData = new BlockMetaData();
                blockMetaData.setRowCount(rowGroup.getNum_rows());
                blockMetaData.setTotalByteSize(rowGroup.getTotal_byte_size());
                List columns = rowGroup.getColumns();
                ParquetValidationUtils.validateParquet(!columns.isEmpty(), "No columns in row group: %s", rowGroup);
                String filePath = ((ColumnChunk)columns.get(0)).getFile_path();
                for (ColumnChunk columnChunk : columns) {
                    ParquetValidationUtils.validateParquet(filePath == null && columnChunk.getFile_path() == null || filePath != null && filePath.equals(columnChunk.getFile_path()), "all column chunks of the same row group must be in the same file", new Object[0]);
                    ColumnMetaData metaData = columnChunk.meta_data;
                    String[] path = (String[])metaData.path_in_schema.stream().map(value -> value.toLowerCase(Locale.ENGLISH)).toArray(String[]::new);
                    ColumnPath columnPath = ColumnPath.get((String[])path);
                    PrimitiveType primitiveType = messageType.getType(columnPath.toArray()).asPrimitiveType();
                    ColumnChunkMetaData column = ColumnChunkMetaData.get((ColumnPath)columnPath, (PrimitiveType)primitiveType, (CompressionCodecName)CompressionCodecName.fromParquet((CompressionCodec)metaData.codec), (EncodingStats)PARQUET_METADATA_CONVERTER.convertEncodingStats(metaData.encoding_stats), MetadataReader.readEncodings(metaData.encodings), MetadataReader.readStats(Optional.ofNullable(fileMetaData.getCreated_by()), Optional.ofNullable(metaData.statistics), primitiveType), (long)metaData.data_page_offset, (long)metaData.dictionary_page_offset, (long)metaData.num_values, (long)metaData.total_compressed_size, (long)metaData.total_uncompressed_size);
                    blockMetaData.addColumn(column);
                }
                blockMetaData.setPath(filePath);
                blocks.add(blockMetaData);
            }
        }
        HashMap<String, String> keyValueMetaData = new HashMap<String, String>();
        List keyValueList = fileMetaData.getKey_value_metadata();
        if (keyValueList != null) {
            for (KeyValue keyValue : keyValueList) {
                keyValueMetaData.put(keyValue.key, keyValue.value);
            }
        }
        return new ParquetMetadata(new FileMetaData(messageType, keyValueMetaData, fileMetaData.getCreated_by()), blocks);
    }

    private static MessageType readParquetSchema(List<SchemaElement> schema) {
        Iterator<SchemaElement> schemaIterator = schema.iterator();
        SchemaElement rootSchema = schemaIterator.next();
        Types.MessageTypeBuilder builder = Types.buildMessage();
        MetadataReader.readTypeSchema(builder, schemaIterator, rootSchema.getNum_children());
        return builder.named(rootSchema.name);
    }

    private static void readTypeSchema(Types.GroupBuilder<?> builder, Iterator<SchemaElement> schemaIterator, int typeCount) {
        for (int i = 0; i < typeCount; ++i) {
            Types.GroupBuilder typeBuilder;
            SchemaElement element = schemaIterator.next();
            if (element.type == null) {
                typeBuilder = builder.group(Type.Repetition.valueOf((String)element.repetition_type.name()));
                MetadataReader.readTypeSchema(typeBuilder, schemaIterator, element.num_children);
            } else {
                Types.PrimitiveBuilder primitiveBuilder = builder.primitive(MetadataReader.getTypeName(element.type), Type.Repetition.valueOf((String)element.repetition_type.name()));
                if (element.isSetType_length()) {
                    primitiveBuilder.length(element.type_length);
                }
                if (element.isSetPrecision()) {
                    primitiveBuilder.precision(element.precision);
                }
                if (element.isSetScale()) {
                    primitiveBuilder.scale(element.scale);
                }
                typeBuilder = primitiveBuilder;
            }
            if (element.isSetConverted_type()) {
                typeBuilder.as(ParquetMetadataConverterUtil.getLogicalTypeAnnotation((ParquetMetadataConverter)new ParquetMetadataConverter(), (ConvertedType)element.converted_type, (SchemaElement)element));
            }
            if (element.isSetField_id()) {
                typeBuilder.id(element.field_id);
            }
            typeBuilder.named(element.name.toLowerCase(Locale.ENGLISH));
        }
    }

    public static Statistics<?> readStats(Optional<String> fileCreatedBy, Optional<org.apache.parquet.format.Statistics> statisticsFromFile, PrimitiveType type) {
        org.apache.parquet.format.Statistics statistics = statisticsFromFile.orElse(null);
        Statistics columnStatistics = new ParquetMetadataConverter().fromParquetStatistics((String)fileCreatedBy.orElse(null), statistics, type);
        if (MetadataReader.isStringType(type) && statistics != null && !statistics.isSetMin_value() && !statistics.isSetMax_value() && statistics.isSetMin() && statistics.isSetMax() && columnStatistics.genericGetMin() == null && columnStatistics.genericGetMax() == null && !CorruptStatistics.shouldIgnoreStatistics((String)fileCreatedBy.orElse(null), (PrimitiveType.PrimitiveTypeName)type.getPrimitiveTypeName())) {
            MetadataReader.tryReadOldUtf8Stats(statistics, (BinaryStatistics)columnStatistics);
        }
        return columnStatistics;
    }

    private static boolean isStringType(PrimitiveType type) {
        if (type.getLogicalTypeAnnotation() == null) {
            return false;
        }
        return type.getLogicalTypeAnnotation().accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Boolean>(){

            public Optional<Boolean> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
                return Optional.of(Boolean.TRUE);
            }
        }).orElse(Boolean.FALSE);
    }

    private static void tryReadOldUtf8Stats(org.apache.parquet.format.Statistics statistics, BinaryStatistics columnStatistics) {
        byte[] max;
        byte[] min = statistics.getMin();
        if (Arrays.equals(min, max = statistics.getMax())) {
            min = (byte[])min.clone();
            max = min;
        } else {
            int commonPrefix;
            int minGoodLength;
            for (minGoodLength = commonPrefix = MetadataReader.commonPrefix(min, max); minGoodLength < min.length && MetadataReader.isAscii(min[minGoodLength]); ++minGoodLength) {
            }
            int maxGoodLength = commonPrefix;
            if (maxGoodLength < max.length && maxGoodLength < min.length && MetadataReader.isAscii(min[maxGoodLength]) && MetadataReader.isAscii(max[maxGoodLength])) {
                ++maxGoodLength;
            }
            while (!(maxGoodLength <= 0 || max[maxGoodLength - 1] != 127 && MetadataReader.isAscii(max[maxGoodLength - 1]))) {
                --maxGoodLength;
            }
            if (maxGoodLength == 0) {
                return;
            }
            min = Arrays.copyOf(min, minGoodLength);
            max = Arrays.copyOf(max, maxGoodLength);
            int n = maxGoodLength - 1;
            max[n] = (byte)(max[n] + 1);
        }
        columnStatistics.setMinMaxFromBytes(min, max);
        if (!columnStatistics.isNumNullsSet() && statistics.isSetNull_count()) {
            columnStatistics.setNumNulls(statistics.getNull_count());
        }
    }

    private static boolean isAscii(byte b) {
        return 0 <= b;
    }

    private static int commonPrefix(byte[] a, byte[] b) {
        int commonPrefixLength;
        for (commonPrefixLength = 0; commonPrefixLength < a.length && commonPrefixLength < b.length && a[commonPrefixLength] == b[commonPrefixLength]; ++commonPrefixLength) {
        }
        return commonPrefixLength;
    }

    private static Set<org.apache.parquet.column.Encoding> readEncodings(List<Encoding> encodings) {
        HashSet<org.apache.parquet.column.Encoding> columnEncodings = new HashSet<org.apache.parquet.column.Encoding>();
        for (Encoding encoding : encodings) {
            columnEncodings.add(org.apache.parquet.column.Encoding.valueOf((String)encoding.name()));
        }
        return Collections.unmodifiableSet(columnEncodings);
    }

    private static PrimitiveType.PrimitiveTypeName getTypeName(Type type) {
        switch (type) {
            case BYTE_ARRAY: {
                return PrimitiveType.PrimitiveTypeName.BINARY;
            }
            case INT64: {
                return PrimitiveType.PrimitiveTypeName.INT64;
            }
            case INT32: {
                return PrimitiveType.PrimitiveTypeName.INT32;
            }
            case BOOLEAN: {
                return PrimitiveType.PrimitiveTypeName.BOOLEAN;
            }
            case FLOAT: {
                return PrimitiveType.PrimitiveTypeName.FLOAT;
            }
            case DOUBLE: {
                return PrimitiveType.PrimitiveTypeName.DOUBLE;
            }
            case INT96: {
                return PrimitiveType.PrimitiveTypeName.INT96;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }
}

