/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.reader;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.parquet.ChunkKey;
import io.prestosql.parquet.ChunkReader;
import io.prestosql.parquet.DiskRange;
import io.prestosql.parquet.Field;
import io.prestosql.parquet.GroupField;
import io.prestosql.parquet.ParquetCorruptionException;
import io.prestosql.parquet.ParquetDataSource;
import io.prestosql.parquet.ParquetReaderOptions;
import io.prestosql.parquet.ParquetValidationUtils;
import io.prestosql.parquet.PrimitiveField;
import io.prestosql.parquet.RichColumnDescriptor;
import io.prestosql.parquet.reader.ColumnChunk;
import io.prestosql.parquet.reader.ColumnChunkDescriptor;
import io.prestosql.parquet.reader.ListColumnReader;
import io.prestosql.parquet.reader.ParquetColumnChunk;
import io.prestosql.parquet.reader.PrimitiveColumnReader;
import io.prestosql.parquet.reader.StructColumnReader;
import io.prestosql.spi.block.ArrayBlock;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.RowBlock;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.joda.time.DateTimeZone;

public class ParquetReader
implements Closeable {
    private static final int MAX_VECTOR_LENGTH = 1024;
    private static final int INITIAL_BATCH_SIZE = 1;
    private static final int BATCH_SIZE_GROWTH_FACTOR = 2;
    private final Optional<String> fileCreatedBy;
    private final List<BlockMetaData> blocks;
    private final List<PrimitiveColumnIO> columns;
    private final ParquetDataSource dataSource;
    private final DateTimeZone timeZone;
    private final AggregatedMemoryContext systemMemoryContext;
    private int currentRowGroup = -1;
    private BlockMetaData currentBlockMetadata;
    private long currentGroupRowCount;
    private long nextRowInGroup;
    private int batchSize;
    private int nextBatchSize = 1;
    private final PrimitiveColumnReader[] columnReaders;
    private final long[] maxBytesPerCell;
    private long maxCombinedBytesPerRow;
    private final ParquetReaderOptions options;
    private int maxBatchSize = 1024;
    private AggregatedMemoryContext currentRowGroupMemoryContext;
    private final Map<ChunkKey, ChunkReader> chunkReaders;

    public ParquetReader(Optional<String> fileCreatedBy, MessageColumnIO messageColumnIO, List<BlockMetaData> blocks, ParquetDataSource dataSource, DateTimeZone timeZone, AggregatedMemoryContext systemMemoryContext, ParquetReaderOptions options) throws IOException {
        this.fileCreatedBy = Objects.requireNonNull(fileCreatedBy, "fileCreatedBy is null");
        this.columns = Objects.requireNonNull(messageColumnIO, "messageColumnIO is null").getLeaves();
        this.blocks = Objects.requireNonNull(blocks, "blocks is null");
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource is null");
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.currentRowGroupMemoryContext = systemMemoryContext.newAggregatedMemoryContext();
        this.options = Objects.requireNonNull(options, "options is null");
        this.columnReaders = new PrimitiveColumnReader[this.columns.size()];
        this.maxBytesPerCell = new long[this.columns.size()];
        HashMap<ChunkKey, DiskRange> ranges = new HashMap<ChunkKey, DiskRange>();
        for (int rowGroup = 0; rowGroup < blocks.size(); ++rowGroup) {
            BlockMetaData metadata = blocks.get(rowGroup);
            for (PrimitiveColumnIO column : this.columns) {
                int columnId = column.getId();
                ColumnChunkMetaData chunkMetadata = this.getColumnChunkMetaData(metadata, column.getColumnDescriptor());
                DiskRange range = new DiskRange(chunkMetadata.getStartingPos(), Math.toIntExact(chunkMetadata.getTotalSize()));
                ranges.put(new ChunkKey(columnId, rowGroup), range);
            }
        }
        this.chunkReaders = dataSource.planRead(ranges);
    }

    @Override
    public void close() throws IOException {
        this.freeCurrentRowGroupBuffers();
        this.currentRowGroupMemoryContext.close();
        this.dataSource.close();
    }

    public int nextBatch() {
        if (this.nextRowInGroup >= this.currentGroupRowCount && !this.advanceToNextRowGroup()) {
            return -1;
        }
        this.batchSize = Math.min(this.nextBatchSize, this.maxBatchSize);
        this.nextBatchSize = Math.min(this.batchSize * 2, 1024);
        this.batchSize = Math.toIntExact(Math.min((long)this.batchSize, this.currentGroupRowCount - this.nextRowInGroup));
        this.nextRowInGroup += (long)this.batchSize;
        Arrays.stream(this.columnReaders).forEach(reader -> reader.prepareNextRead(this.batchSize));
        return this.batchSize;
    }

    private boolean advanceToNextRowGroup() {
        this.currentRowGroupMemoryContext.close();
        this.currentRowGroupMemoryContext = this.systemMemoryContext.newAggregatedMemoryContext();
        this.freeCurrentRowGroupBuffers();
        ++this.currentRowGroup;
        if (this.currentRowGroup == this.blocks.size()) {
            return false;
        }
        this.currentBlockMetadata = this.blocks.get(this.currentRowGroup);
        this.nextRowInGroup = 0L;
        this.currentGroupRowCount = this.currentBlockMetadata.getRowCount();
        this.initializeColumnReaders();
        return true;
    }

    private void freeCurrentRowGroupBuffers() {
        if (this.currentRowGroup < 0) {
            return;
        }
        for (int column = 0; column < this.columns.size(); ++column) {
            ChunkReader reader = this.chunkReaders.get(new ChunkKey(column, this.currentRowGroup));
            if (reader == null) continue;
            reader.free();
        }
    }

    private ColumnChunk readArray(GroupField field) throws IOException {
        List parameters = field.getType().getTypeParameters();
        Preconditions.checkArgument((parameters.size() == 1 ? 1 : 0) != 0, (String)"Arrays must have a single type parameter, found %s", (int)parameters.size());
        Field elementField = field.getChildren().get(0).get();
        ColumnChunk columnChunk = this.readColumnChunk(elementField);
        IntArrayList offsets = new IntArrayList();
        BooleanArrayList valueIsNull = new BooleanArrayList();
        ListColumnReader.calculateCollectionOffsets(field, (IntList)offsets, (BooleanList)valueIsNull, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        Block arrayBlock = ArrayBlock.fromElementBlock((int)valueIsNull.size(), Optional.of(valueIsNull.toBooleanArray()), (int[])offsets.toIntArray(), (Block)columnChunk.getBlock());
        return new ColumnChunk(arrayBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private ColumnChunk readMap(GroupField field) throws IOException {
        List parameters = field.getType().getTypeParameters();
        Preconditions.checkArgument((parameters.size() == 2 ? 1 : 0) != 0, (String)"Maps must have two type parameters, found %s", (int)parameters.size());
        Block[] blocks = new Block[parameters.size()];
        ColumnChunk columnChunk = this.readColumnChunk(field.getChildren().get(0).get());
        blocks[0] = columnChunk.getBlock();
        blocks[1] = this.readColumnChunk(field.getChildren().get(1).get()).getBlock();
        IntArrayList offsets = new IntArrayList();
        BooleanArrayList valueIsNull = new BooleanArrayList();
        ListColumnReader.calculateCollectionOffsets(field, (IntList)offsets, (BooleanList)valueIsNull, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        Block mapBlock = ((MapType)field.getType()).createBlockFromKeyValue(Optional.of(valueIsNull.toBooleanArray()), offsets.toIntArray(), blocks[0], blocks[1]);
        return new ColumnChunk(mapBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private ColumnChunk readStruct(GroupField field) throws IOException {
        int i;
        List fields = field.getType().getTypeSignature().getParameters();
        Block[] blocks = new Block[fields.size()];
        ColumnChunk columnChunk = null;
        List<Optional<Field>> parameters = field.getChildren();
        for (i = 0; i < fields.size(); ++i) {
            Optional<Field> parameter = parameters.get(i);
            if (!parameter.isPresent()) continue;
            columnChunk = this.readColumnChunk(parameter.get());
            blocks[i] = columnChunk.getBlock();
        }
        for (i = 0; i < fields.size(); ++i) {
            if (blocks[i] != null) continue;
            blocks[i] = RunLengthEncodedBlock.create((Type)field.getType(), null, (int)columnChunk.getBlock().getPositionCount());
        }
        BooleanList structIsNull = StructColumnReader.calculateStructOffsets(field, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        boolean[] structIsNullVector = structIsNull.toBooleanArray();
        Block rowBlock = RowBlock.fromFieldBlocks((int)structIsNullVector.length, Optional.of(structIsNullVector), (Block[])blocks);
        return new ColumnChunk(rowBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private ColumnChunk readPrimitive(PrimitiveField field) throws IOException {
        ColumnChunk columnChunk;
        long bytesPerCell;
        RichColumnDescriptor columnDescriptor = field.getDescriptor();
        int fieldId = field.getId();
        PrimitiveColumnReader columnReader = this.columnReaders[fieldId];
        if (columnReader.getPageReader() == null) {
            ParquetValidationUtils.validateParquet(this.currentBlockMetadata.getRowCount() > 0L, "Row group has 0 rows", new Object[0]);
            ColumnChunkMetaData metadata = this.getColumnChunkMetaData(this.currentBlockMetadata, columnDescriptor);
            Slice data = this.chunkReaders.get(new ChunkKey(fieldId, this.currentRowGroup)).read();
            this.currentRowGroupMemoryContext.newLocalMemoryContext(ParquetReader.class.getSimpleName()).setBytes((long)data.length());
            ColumnChunkDescriptor descriptor = new ColumnChunkDescriptor(columnDescriptor, metadata);
            ParquetColumnChunk columnChunk2 = new ParquetColumnChunk(this.fileCreatedBy, descriptor, data);
            columnReader.setPageReader(columnChunk2.readAllPages());
        }
        if (this.maxBytesPerCell[fieldId] < (bytesPerCell = (columnChunk = columnReader.readPrimitive(field)).getBlock().getSizeInBytes() / (long)this.batchSize)) {
            this.maxCombinedBytesPerRow = this.maxCombinedBytesPerRow - this.maxBytesPerCell[fieldId] + bytesPerCell;
            this.maxBatchSize = Math.toIntExact(Math.min((long)this.maxBatchSize, Math.max(1L, this.options.getMaxReadBlockSize().toBytes() / this.maxCombinedBytesPerRow)));
            this.maxBytesPerCell[fieldId] = bytesPerCell;
        }
        return columnChunk;
    }

    private ColumnChunkMetaData getColumnChunkMetaData(BlockMetaData blockMetaData, ColumnDescriptor columnDescriptor) throws IOException {
        for (ColumnChunkMetaData metadata : blockMetaData.getColumns()) {
            if (!metadata.getPath().equals((Object)ColumnPath.get((String[])columnDescriptor.getPath()))) continue;
            return metadata;
        }
        throw new ParquetCorruptionException("Metadata is missing for column: %s", columnDescriptor);
    }

    private void initializeColumnReaders() {
        for (PrimitiveColumnIO columnIO : this.columns) {
            RichColumnDescriptor column = new RichColumnDescriptor(columnIO.getColumnDescriptor(), columnIO.getType().asPrimitiveType());
            this.columnReaders[columnIO.getId()] = PrimitiveColumnReader.createReader(column, this.timeZone);
        }
    }

    public Block readBlock(Field field) throws IOException {
        return this.readColumnChunk(field).getBlock();
    }

    private ColumnChunk readColumnChunk(Field field) throws IOException {
        ColumnChunk columnChunk = field.getType() instanceof RowType ? this.readStruct((GroupField)field) : (field.getType() instanceof MapType ? this.readMap((GroupField)field) : (field.getType() instanceof ArrayType ? this.readArray((GroupField)field) : this.readPrimitive((PrimitiveField)field)));
        return columnChunk;
    }

    public ParquetDataSource getDataSource() {
        return this.dataSource;
    }

    public AggregatedMemoryContext getSystemMemoryContext() {
        return this.systemMemoryContext;
    }
}

