/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.reader;

import io.prestosql.parquet.ParquetTypeUtils;
import io.prestosql.parquet.RichColumnDescriptor;
import io.prestosql.parquet.reader.PrimitiveColumnReader;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DecimalConversions;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import java.util.Objects;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.PrimitiveType;

public class ShortDecimalColumnReader
extends PrimitiveColumnReader {
    private final DecimalType parquetDecimalType;

    ShortDecimalColumnReader(RichColumnDescriptor descriptor, DecimalType parquetDecimalType) {
        super(descriptor);
        this.parquetDecimalType = Objects.requireNonNull(parquetDecimalType, "parquetDecimalType is null");
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type prestoType) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            if (!(prestoType instanceof DecimalType) && !this.isIntegerType(prestoType)) {
                throw new ParquetDecodingException(String.format("Unsupported Presto column type (%s) for Parquet column (%s)", new Object[]{prestoType, this.columnDescriptor}));
            }
            long value = this.columnDescriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32 ? (long)this.valuesReader.readInteger() : (this.columnDescriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64 ? this.valuesReader.readLong() : ParquetTypeUtils.getShortDecimalValue(this.valuesReader.readBytes().getBytes()));
            if (prestoType instanceof DecimalType) {
                DecimalType prestoDecimalType = (DecimalType)prestoType;
                if (Decimals.isShortDecimal((Type)prestoDecimalType)) {
                    long rescale = Decimals.longTenToNth((int)Math.abs(prestoDecimalType.getScale() - this.parquetDecimalType.getScale()));
                    long convertedValue = DecimalConversions.shortToShortCast((long)value, (long)this.parquetDecimalType.getPrecision(), (long)this.parquetDecimalType.getScale(), (long)prestoDecimalType.getPrecision(), (long)prestoDecimalType.getScale(), (long)rescale, (long)(rescale / 2L));
                    prestoType.writeLong(blockBuilder, convertedValue);
                } else if (Decimals.isLongDecimal((Type)prestoDecimalType)) {
                    prestoType.writeSlice(blockBuilder, DecimalConversions.shortToLongCast((long)value, (long)this.parquetDecimalType.getPrecision(), (long)this.parquetDecimalType.getScale(), (long)prestoDecimalType.getPrecision(), (long)prestoDecimalType.getScale()));
                }
            } else {
                if (this.parquetDecimalType.getScale() != 0) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Presto column type (%s) for Parquet column (%s)", new Object[]{prestoType, this.columnDescriptor}));
                }
                if (!this.isInValidNumberRange(prestoType, value)) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Could not coerce from %s to %s: %s", this.parquetDecimalType, prestoType, value));
                }
                prestoType.writeLong(blockBuilder, value);
            }
        } else if (this.isValueNull()) {
            blockBuilder.appendNull();
        }
    }

    protected boolean isIntegerType(Type type) {
        return type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER) || type.equals(BigintType.BIGINT);
    }

    protected boolean isInValidNumberRange(Type type, long value) {
        if (type.equals(TinyintType.TINYINT)) {
            return -128L <= value && value <= 127L;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return -32768L <= value && value <= 32767L;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE;
        }
        if (type.equals(BigintType.BIGINT)) {
            return true;
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            if (this.columnDescriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32) {
                this.valuesReader.readInteger();
            } else if (this.columnDescriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64) {
                this.valuesReader.readLong();
            } else {
                this.valuesReader.readBytes();
            }
        }
    }
}

