/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.reader;

import io.prestosql.parquet.Field;
import io.prestosql.parquet.ParquetTypeUtils;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;

public final class StructColumnReader {
    private StructColumnReader() {
    }

    public static BooleanList calculateStructOffsets(Field field, int[] fieldDefinitionLevels, int[] fieldRepetitionLevels) {
        int maxDefinitionLevel = field.getDefinitionLevel();
        int maxRepetitionLevel = field.getRepetitionLevel();
        BooleanArrayList structIsNull = new BooleanArrayList();
        boolean required = field.isRequired();
        if (fieldDefinitionLevels == null) {
            return structIsNull;
        }
        for (int i = 0; i < fieldDefinitionLevels.length; ++i) {
            if (fieldRepetitionLevels[i] > maxRepetitionLevel) continue;
            if (ParquetTypeUtils.isValueNull(required, fieldDefinitionLevels[i], maxDefinitionLevel)) {
                structIsNull.add(true);
                continue;
            }
            if (fieldDefinitionLevels[i] < maxDefinitionLevel) continue;
            structIsNull.add(false);
        }
        return structIsNull;
    }
}

