/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.reader;

import io.prestosql.parquet.ParquetTimestampUtils;
import io.prestosql.parquet.RichColumnDescriptor;
import io.prestosql.parquet.reader.PrimitiveColumnReader;
import io.prestosql.plugin.base.type.DecodedTimestamp;
import io.prestosql.plugin.base.type.PrestoTimestampEncoder;
import io.prestosql.plugin.base.type.PrestoTimestampEncoderFactory;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public class TimestampColumnReader
extends PrimitiveColumnReader {
    private final DateTimeZone timeZone;

    public TimestampColumnReader(RichColumnDescriptor descriptor, DateTimeZone timeZone) {
        super(descriptor);
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            if (type instanceof TimestampWithTimeZoneType) {
                DecodedTimestamp decodedTimestamp = ParquetTimestampUtils.decode(this.valuesReader.readBytes());
                long utcMillis = decodedTimestamp.getEpochSeconds() * 1000L + (long)(decodedTimestamp.getNanosOfSecond() / 1000000);
                type.writeLong(blockBuilder, DateTimeEncoding.packDateTimeWithZone((long)utcMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY));
            } else {
                PrestoTimestampEncoder prestoTimestampEncoder = PrestoTimestampEncoderFactory.createTimestampEncoder((TimestampType)((TimestampType)type), (DateTimeZone)this.timeZone);
                prestoTimestampEncoder.write(ParquetTimestampUtils.decode(this.valuesReader.readBytes()), blockBuilder);
            }
        } else if (this.isValueNull()) {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            this.valuesReader.readBytes();
        }
    }
}

