/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.writer;

import io.prestosql.parquet.writer.ColumnChunk;
import io.prestosql.parquet.writer.ParquetDataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.parquet.format.ColumnMetaData;

public interface ColumnWriter {
    public void writeBlock(ColumnChunk var1) throws IOException;

    public void close();

    public List<BufferData> getBuffer() throws IOException;

    public long getBufferedBytes();

    public long getRetainedBytes();

    public void reset();

    public static class BufferData {
        private final ColumnMetaData metaData;
        private final List<ParquetDataOutput> data;

        public BufferData(List<ParquetDataOutput> data, ColumnMetaData metaData) {
            this.data = Objects.requireNonNull(data, "data is null");
            this.metaData = Objects.requireNonNull(metaData, "metaData is null");
        }

        public ColumnMetaData getMetaData() {
            return this.metaData;
        }

        public List<ParquetDataOutput> getData() {
            return this.data;
        }
    }
}

