/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.writer;

import io.airlift.units.DataSize;
import java.util.Objects;

public class ParquetWriterOptions {
    private static final DataSize DEFAULT_MAX_ROW_GROUP_SIZE = DataSize.ofBytes((long)0x8000000L);
    private static final DataSize DEFAULT_MAX_PAGE_SIZE = DataSize.ofBytes((long)0x100000L);
    private final int maxRowGroupSize;
    private final int maxPageSize;

    public static Builder builder() {
        return new Builder();
    }

    private ParquetWriterOptions(DataSize maxBlockSize, DataSize maxPageSize) {
        this.maxRowGroupSize = Math.toIntExact(Objects.requireNonNull(maxBlockSize, "maxRowGroupSize is null").toBytes());
        this.maxPageSize = Math.toIntExact(Objects.requireNonNull(maxPageSize, "maxPageSize is null").toBytes());
    }

    public long getMaxRowGroupSize() {
        return this.maxRowGroupSize;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public static class Builder {
        private DataSize maxBlockSize = DEFAULT_MAX_ROW_GROUP_SIZE;
        private DataSize maxPageSize = DEFAULT_MAX_PAGE_SIZE;

        public Builder setMaxBlockSize(DataSize maxBlockSize) {
            this.maxBlockSize = maxBlockSize;
            return this;
        }

        public Builder setMaxPageSize(DataSize maxPageSize) {
            this.maxPageSize = maxPageSize;
            return this;
        }

        public ParquetWriterOptions build() {
            return new ParquetWriterOptions(this.maxBlockSize, this.maxPageSize);
        }
    }
}

