/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.writer.valuewriter;

import io.airlift.slice.Slice;
import io.prestosql.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.Type;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;

public class DecimalValueWriter
extends PrimitiveValueWriter {
    private final DecimalType decimalType;

    public DecimalValueWriter(ValuesWriter valuesWriter, Type type, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
        this.decimalType = (DecimalType)Objects.requireNonNull(type, "type is null");
    }

    @Override
    public void write(Block block) {
        if (this.decimalType.getPrecision() <= 9) {
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) continue;
                int value = (int)this.decimalType.getLong(block, i);
                this.getValueWriter().writeInteger(value);
                this.getStatistics().updateStats(value);
            }
        } else if (this.decimalType.isShort()) {
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) continue;
                long value = this.decimalType.getLong(block, i);
                this.getValueWriter().writeLong(value);
                this.getStatistics().updateStats(value);
            }
        } else {
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) continue;
                Slice slice = this.decimalType.getSlice(block, i);
                BigInteger bigInteger = Decimals.decodeUnscaledValue((Slice)slice);
                Binary binary = Binary.fromConstantByteArray((byte[])this.paddingBigInteger(bigInteger));
                this.getValueWriter().writeBytes(binary);
                this.getStatistics().updateStats(binary);
            }
        }
    }

    private byte[] paddingBigInteger(BigInteger bigInteger) {
        byte[] result = new byte[this.getTypeLength()];
        if (bigInteger.signum() < 0) {
            Arrays.fill(result, (byte)-1);
        }
        byte[] bytes = bigInteger.toByteArray();
        int i = bytes.length - 1;
        int j = result.length - 1;
        while (i >= 0) {
            result[j] = bytes[i];
            --i;
            --j;
        }
        return result;
    }
}

