/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.writer.valuewriter;

import io.prestosql.spi.block.Block;
import java.util.Objects;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public abstract class PrimitiveValueWriter
extends ValuesWriter {
    private Statistics<?> statistics;
    private final PrimitiveType parquetType;
    private final ValuesWriter valuesWriter;

    public PrimitiveValueWriter(PrimitiveType parquetType, ValuesWriter valuesWriter) {
        this.parquetType = Objects.requireNonNull(parquetType, "parquetType is null");
        this.valuesWriter = Objects.requireNonNull(valuesWriter, "valuesWriter is null");
        this.statistics = Statistics.createStats((Type)parquetType);
    }

    ValuesWriter getValueWriter() {
        return this.valuesWriter;
    }

    public Statistics<?> getStatistics() {
        return this.statistics;
    }

    protected int getTypeLength() {
        return this.parquetType.getTypeLength();
    }

    public long getBufferedSize() {
        return this.valuesWriter.getBufferedSize();
    }

    public BytesInput getBytes() {
        return this.valuesWriter.getBytes();
    }

    public Encoding getEncoding() {
        return this.valuesWriter.getEncoding();
    }

    public void reset() {
        this.valuesWriter.reset();
        this.statistics = Statistics.createStats((Type)this.parquetType);
    }

    public void close() {
        this.valuesWriter.close();
    }

    public DictionaryPage toDictPageAndClose() {
        return this.valuesWriter.toDictPageAndClose();
    }

    public void resetDictionary() {
        this.valuesWriter.resetDictionary();
    }

    public long getAllocatedSize() {
        return this.valuesWriter.getAllocatedSize();
    }

    public String memUsageString(String prefix) {
        return this.valuesWriter.memUsageString(prefix);
    }

    public abstract void write(Block var1);
}

