/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.writer.valuewriter;

import io.prestosql.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.TimeType;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class TimeMicrosValueWriter
extends PrimitiveValueWriter {
    public TimeMicrosValueWriter(ValuesWriter valuesWriter, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
    }

    @Override
    public void write(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) continue;
            long scaledValue = TimeType.TIME_MICROS.getLong(block, i) / 1000000L;
            this.getValueWriter().writeLong(scaledValue);
            this.getStatistics().updateStats(scaledValue);
        }
    }
}

