/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.writer.valuewriter;

import io.prestosql.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Type;
import java.util.Objects;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class TimestampMillisValueWriter
extends PrimitiveValueWriter {
    private final Type type;

    public TimestampMillisValueWriter(ValuesWriter valuesWriter, Type type, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
        this.type = Objects.requireNonNull(type, "type is null");
    }

    @Override
    public void write(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) continue;
            long scaledValue = Math.floorDiv(this.type.getLong(block, i), 1000);
            this.getValueWriter().writeLong(scaledValue);
            this.getStatistics().updateStats(scaledValue);
        }
    }
}

