/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.writer.valuewriter;

import io.prestosql.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class TimestampTzMillisValueWriter
extends PrimitiveValueWriter {
    public TimestampTzMillisValueWriter(ValuesWriter valuesWriter, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
    }

    @Override
    public void write(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) continue;
            long millis = DateTimeEncoding.unpackMillisUtc((long)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.getLong(block, i));
            this.getValueWriter().writeLong(millis);
            this.getStatistics().updateStats(millis);
        }
    }
}

