/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FetchFirst
extends Node {
    private final Optional<String> rowCount;

    public FetchFirst(String rowCount) {
        this(Optional.empty(), Optional.of(rowCount));
    }

    public FetchFirst(Optional<String> rowCount) {
        this(Optional.empty(), rowCount);
    }

    public FetchFirst(NodeLocation location, Optional<String> rowCount) {
        this(Optional.of(location), rowCount);
    }

    public FetchFirst(Optional<NodeLocation> location, Optional<String> rowCount) {
        super(location);
        this.rowCount = rowCount;
    }

    public Optional<String> getRowCount() {
        return this.rowCount;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFetchFirst(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FetchFirst o = (FetchFirst)obj;
        return Objects.equals(this.rowCount, o.rowCount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rowCount);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rowCount", this.rowCount.orElse(null)).omitNullValues().toString();
    }
}

