/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public class Identifier
extends Expression {
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z_]([a-zA-Z0-9_])*");
    private final String value;
    private final boolean delimited;

    public Identifier(NodeLocation location, String value, boolean delimited) {
        this(Optional.of(location), value, delimited);
    }

    public Identifier(String value, boolean delimited) {
        this(Optional.empty(), value, delimited);
    }

    public Identifier(String value) {
        this(Optional.empty(), value, !NAME_PATTERN.matcher(value).matches());
    }

    private Identifier(Optional<NodeLocation> location, String value, boolean delimited) {
        super(location);
        this.value = Objects.requireNonNull(value, "value is null");
        this.delimited = delimited;
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)"value is empty");
        Preconditions.checkArgument((delimited || NAME_PATTERN.matcher(value).matches() ? 1 : 0) != 0, (String)"value contains illegal characters: %s", (Object)value);
    }

    public String getValue() {
        return this.value;
    }

    public boolean isDelimited() {
        return this.delimited;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIdentifier(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identifier that = (Identifier)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Identifier.sameClass(this, other)) {
            return false;
        }
        Identifier that = (Identifier)other;
        return Objects.equals(this.value, that.value) && this.delimited == that.delimited;
    }
}

