/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.Config;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import io.prestosql.plugin.jdbc.credential.CredentialProviderType;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class BaseJdbcConfig {
    private String connectionUrl;
    private String userCredentialName;
    private String passwordCredentialName;
    private boolean caseInsensitiveNameMatching;
    private Duration caseInsensitiveNameMatchingCacheTtl = new Duration(1.0, TimeUnit.MINUTES);
    private CredentialProviderType credentialProviderType = CredentialProviderType.INLINE;
    private Set<String> jdbcTypesMappedToVarchar = ImmutableSet.of();

    @NotNull
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Config(value="connection-url")
    public BaseJdbcConfig setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    @Nullable
    public String getUserCredentialName() {
        return this.userCredentialName;
    }

    @Config(value="user-credential-name")
    public BaseJdbcConfig setUserCredentialName(String userCredentialName) {
        this.userCredentialName = userCredentialName;
        return this;
    }

    @Nullable
    public String getPasswordCredentialName() {
        return this.passwordCredentialName;
    }

    @Config(value="password-credential-name")
    public BaseJdbcConfig setPasswordCredentialName(String passwordCredentialName) {
        this.passwordCredentialName = passwordCredentialName;
        return this;
    }

    public boolean isCaseInsensitiveNameMatching() {
        return this.caseInsensitiveNameMatching;
    }

    @Config(value="case-insensitive-name-matching")
    public BaseJdbcConfig setCaseInsensitiveNameMatching(boolean caseInsensitiveNameMatching) {
        this.caseInsensitiveNameMatching = caseInsensitiveNameMatching;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public Duration getCaseInsensitiveNameMatchingCacheTtl() {
        return this.caseInsensitiveNameMatchingCacheTtl;
    }

    @Config(value="case-insensitive-name-matching.cache-ttl")
    public BaseJdbcConfig setCaseInsensitiveNameMatchingCacheTtl(Duration caseInsensitiveNameMatchingCacheTtl) {
        this.caseInsensitiveNameMatchingCacheTtl = caseInsensitiveNameMatchingCacheTtl;
        return this;
    }

    @NotNull
    public CredentialProviderType getCredentialProviderType() {
        return this.credentialProviderType;
    }

    @Config(value="credential-provider.type")
    public BaseJdbcConfig setCredentialProviderType(CredentialProviderType credentialProviderType) {
        this.credentialProviderType = Objects.requireNonNull(credentialProviderType, "credentialProviderType is null");
        return this;
    }

    public Set<String> getJdbcTypesMappedToVarchar() {
        return this.jdbcTypesMappedToVarchar;
    }

    @Config(value="jdbc-types-mapped-to-varchar")
    public BaseJdbcConfig setJdbcTypesMappedToVarchar(String jdbcTypesMappedToVarchar) {
        this.jdbcTypesMappedToVarchar = ImmutableSet.copyOf((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)Strings.nullToEmpty((String)jdbcTypesMappedToVarchar)));
        return this;
    }
}

