/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcOutputTableHandle;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorNewTableLayout;
import io.prestosql.spi.connector.ConnectorOutputMetadata;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.LimitApplicationResult;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.statistics.ComputedStatistics;
import io.prestosql.spi.statistics.TableStatistics;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicReference;

public class JdbcMetadata
implements ConnectorMetadata {
    private final JdbcClient jdbcClient;
    private final boolean allowDropTable;
    private final AtomicReference<Runnable> rollbackAction = new AtomicReference();

    public JdbcMetadata(JdbcClient jdbcClient, boolean allowDropTable) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "client is null");
        this.allowDropTable = allowDropTable;
    }

    public boolean schemaExists(ConnectorSession session, String schemaName) {
        return this.jdbcClient.schemaExists(JdbcIdentity.from(session), schemaName);
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.copyOf(this.jdbcClient.getSchemaNames(JdbcIdentity.from(session)));
    }

    public JdbcTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return this.jdbcClient.getTableHandle(JdbcIdentity.from(session), tableName).orElse(null);
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        TupleDomain newDomain;
        JdbcTableHandle handle = (JdbcTableHandle)table;
        TupleDomain<ColumnHandle> oldDomain = handle.getConstraint();
        if (oldDomain.equals((Object)(newDomain = oldDomain.intersect(constraint.getSummary())))) {
            return Optional.empty();
        }
        handle = new JdbcTableHandle(handle.getSchemaTableName(), handle.getCatalogName(), handle.getSchemaName(), handle.getTableName(), (TupleDomain<ColumnHandle>)newDomain, handle.getLimit());
        return Optional.of(new ConstraintApplicationResult((Object)handle, constraint.getSummary()));
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle table, long limit) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        if (!this.jdbcClient.supportsLimit()) {
            return Optional.empty();
        }
        if (handle.getLimit().isPresent() && handle.getLimit().getAsLong() <= limit) {
            return Optional.empty();
        }
        handle = new JdbcTableHandle(handle.getSchemaTableName(), handle.getCatalogName(), handle.getSchemaName(), handle.getTableName(), handle.getConstraint(), OptionalLong.of(limit));
        return Optional.of(new LimitApplicationResult((Object)handle, this.jdbcClient.isLimitGuaranteed()));
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        return new ConnectorTableProperties();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        ImmutableList.Builder columnMetadata = ImmutableList.builder();
        for (JdbcColumnHandle column : this.jdbcClient.getColumns(session, handle)) {
            columnMetadata.add((Object)column.getColumnMetadata());
        }
        return new ConnectorTableMetadata(handle.getSchemaTableName(), (List)columnMetadata.build());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return this.jdbcClient.getTableNames(JdbcIdentity.from(session), schemaName);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        JdbcTableHandle jdbcTableHandle = (JdbcTableHandle)tableHandle;
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (JdbcColumnHandle column : this.jdbcClient.getColumns(session, jdbcTableHandle)) {
            columnHandles.put((Object)column.getColumnMetadata().getName(), (Object)column);
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder columns = ImmutableMap.builder();
        List tables = prefix.toOptionalSchemaTableName().map(ImmutableList::of).orElseGet(() -> this.listTables(session, prefix.getSchema()));
        for (SchemaTableName tableName : tables) {
            try {
                this.jdbcClient.getTableHandle(JdbcIdentity.from(session), tableName).ifPresent(tableHandle -> columns.put((Object)tableName, (Object)this.getTableMetadata(session, (ConnectorTableHandle)tableHandle).getColumns()));
            }
            catch (TableNotFoundException tableNotFoundException) {}
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((JdbcColumnHandle)columnHandle).getColumnMetadata();
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        if (!this.allowDropTable) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "DROP TABLE is disabled in this catalog");
        }
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        this.jdbcClient.dropTable(JdbcIdentity.from(session), handle);
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        JdbcOutputTableHandle handle = this.jdbcClient.beginCreateTable(session, tableMetadata);
        this.setRollback(() -> this.jdbcClient.rollbackCreateTable(JdbcIdentity.from(session), handle));
        return handle;
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        this.jdbcClient.createTable(session, tableMetadata);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        JdbcOutputTableHandle handle = (JdbcOutputTableHandle)tableHandle;
        this.jdbcClient.commitCreateTable(JdbcIdentity.from(session), handle);
        this.clearRollback();
        return Optional.empty();
    }

    private void setRollback(Runnable action) {
        Preconditions.checkState((boolean)this.rollbackAction.compareAndSet(null, action), (Object)"rollback action is already set");
    }

    private void clearRollback() {
        this.rollbackAction.set(null);
    }

    public void rollback() {
        Optional.ofNullable(this.rollbackAction.getAndSet(null)).ifPresent(Runnable::run);
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        JdbcOutputTableHandle handle = this.jdbcClient.beginInsertTable(session, this.getTableMetadata(session, tableHandle));
        this.setRollback(() -> this.jdbcClient.rollbackCreateTable(JdbcIdentity.from(session), handle));
        return handle;
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        JdbcOutputTableHandle jdbcInsertHandle = (JdbcOutputTableHandle)tableHandle;
        this.jdbcClient.finishInsertTable(JdbcIdentity.from(session), jdbcInsertHandle);
        return Optional.empty();
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle table, ColumnMetadata columnMetadata) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        this.jdbcClient.addColumn(session, tableHandle, columnMetadata);
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle table, ColumnHandle column) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)column;
        this.jdbcClient.dropColumn(JdbcIdentity.from(session), tableHandle, columnHandle);
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle table, ColumnHandle column, String target) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)column;
        this.jdbcClient.renameColumn(JdbcIdentity.from(session), tableHandle, columnHandle, target);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle table, SchemaTableName newTableName) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        this.jdbcClient.renameTable(JdbcIdentity.from(session), tableHandle, newTableName);
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        return this.jdbcClient.getTableStatistics(session, handle, (TupleDomain<ColumnHandle>)constraint.getSummary());
    }
}

