/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.reflect.Reflection;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.ConfigBinder;
import io.airlift.log.Logger;
import io.prestosql.plugin.base.util.LoggingInvocationHandler;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.ForwardingJdbcClient;
import io.prestosql.plugin.jdbc.InternalBaseJdbc;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcConnector;
import io.prestosql.plugin.jdbc.JdbcMetadataConfig;
import io.prestosql.plugin.jdbc.JdbcMetadataFactory;
import io.prestosql.plugin.jdbc.JdbcPageSinkProvider;
import io.prestosql.plugin.jdbc.JdbcRecordSetProvider;
import io.prestosql.plugin.jdbc.JdbcSplitManager;
import io.prestosql.plugin.jdbc.SessionPropertiesProvider;
import io.prestosql.plugin.jdbc.StatsCollecting;
import io.prestosql.plugin.jdbc.jmx.StatisticsAwareConnectionFactory;
import io.prestosql.plugin.jdbc.jmx.StatisticsAwareJdbcClient;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.procedure.Procedure;
import java.lang.reflect.InvocationHandler;
import java.util.Objects;
import org.weakref.jmx.guice.ExportBinder;

public class JdbcModule
implements Module {
    private final String catalogName;

    public JdbcModule(String catalogName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    public void configure(Binder binder) {
        OptionalBinder.newOptionalBinder((Binder)binder, ConnectorAccessControl.class);
        Multibinder.newSetBinder((Binder)binder, Procedure.class);
        Multibinder.newSetBinder((Binder)binder, SessionPropertiesProvider.class);
        binder.bind(JdbcMetadataFactory.class).in(Scopes.SINGLETON);
        binder.bind(JdbcSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(JdbcRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(JdbcPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(JdbcConnector.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcMetadataConfig.class);
        ExportBinder.newExporter((Binder)binder).export(Key.get(JdbcClient.class, InternalBaseJdbc.class)).as(generator -> generator.generatedNameOf(JdbcClient.class, this.catalogName));
    }

    @Provides
    @Singleton
    @InternalBaseJdbc
    public JdbcClient createJdbcClientWithStats(JdbcClient client) {
        final StatisticsAwareJdbcClient statisticsAwareJdbcClient = new StatisticsAwareJdbcClient(client);
        final Logger logger = Logger.get((String)String.format("io.prestosql.plugin.jdbc.%s.jdbcclient", this.catalogName));
        final JdbcClient loggingInvocationsJdbcClient = (JdbcClient)Reflection.newProxy(JdbcClient.class, (InvocationHandler)new LoggingInvocationHandler((Object)statisticsAwareJdbcClient, (LoggingInvocationHandler.ParameterNamesProvider)new LoggingInvocationHandler.ReflectiveParameterNamesProvider(), arg_0 -> ((Logger)logger).debug(arg_0)));
        return new ForwardingJdbcClient(){

            @Override
            protected JdbcClient getDelegate() {
                if (logger.isDebugEnabled()) {
                    return loggingInvocationsJdbcClient;
                }
                return statisticsAwareJdbcClient;
            }
        };
    }

    @Provides
    @Singleton
    @StatsCollecting
    public static ConnectionFactory createConnectionFactoryWithStats(ConnectionFactory connectionFactory) {
        return new StatisticsAwareConnectionFactory(connectionFactory);
    }
}

