/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.prestosql.plugin.jdbc.BlockWriteFunction;
import io.prestosql.plugin.jdbc.BooleanWriteFunction;
import io.prestosql.plugin.jdbc.DoubleWriteFunction;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcErrorCode;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcOutputTableHandle;
import io.prestosql.plugin.jdbc.LongWriteFunction;
import io.prestosql.plugin.jdbc.SliceWriteFunction;
import io.prestosql.plugin.jdbc.WriteFunction;
import io.prestosql.plugin.jdbc.WriteMapping;
import io.prestosql.plugin.jdbc.WriteNullFunction;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorPageSink;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class JdbcPageSink
implements ConnectorPageSink {
    private final Connection connection;
    private final PreparedStatement statement;
    private final List<Type> columnTypes;
    private final List<WriteFunction> columnWriters;
    private final List<WriteNullFunction> nullWriters;
    private int batchSize;

    public JdbcPageSink(ConnectorSession session, JdbcOutputTableHandle handle, JdbcClient jdbcClient) {
        try {
            this.connection = jdbcClient.getConnection(JdbcIdentity.from(session), handle);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        try {
            this.connection.setAutoCommit(false);
            this.statement = this.connection.prepareStatement(jdbcClient.buildInsertSql(handle));
        }
        catch (SQLException e) {
            JdbcPageSink.closeWithSuppression(this.connection, e);
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        this.columnTypes = handle.getColumnTypes();
        List writeMappings = (List)this.columnTypes.stream().map(type -> {
            WriteMapping writeMapping = jdbcClient.toWriteMapping(session, (Type)type);
            WriteFunction writeFunction = writeMapping.getWriteFunction();
            Verify.verify((type.getJavaType() == writeFunction.getJavaType() ? 1 : 0) != 0, (String)"Presto type %s is not compatible with write function %s accepting %s", (Object)type, (Object)writeFunction, writeFunction.getJavaType());
            return writeMapping;
        }).collect(ImmutableList.toImmutableList());
        this.columnWriters = (List)writeMappings.stream().map(WriteMapping::getWriteFunction).collect(ImmutableList.toImmutableList());
        this.nullWriters = (List)writeMappings.stream().map(WriteMapping::getWriteNullFunction).collect(ImmutableList.toImmutableList());
    }

    public CompletableFuture<?> appendPage(Page page) {
        try {
            for (int position = 0; position < page.getPositionCount(); ++position) {
                for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                    this.appendColumn(page, position, channel);
                }
                this.statement.addBatch();
                ++this.batchSize;
                if (this.batchSize < 1000) continue;
                this.statement.executeBatch();
                this.connection.commit();
                this.connection.setAutoCommit(false);
                this.batchSize = 0;
            }
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        return NOT_BLOCKED;
    }

    private void appendColumn(Page page, int position, int channel) throws SQLException {
        Block block = page.getBlock(channel);
        int parameterIndex = channel + 1;
        if (block.isNull(position)) {
            this.nullWriters.get(channel).setNull(this.statement, parameterIndex);
            return;
        }
        Type type = this.columnTypes.get(channel);
        Class javaType = type.getJavaType();
        WriteFunction writeFunction = this.columnWriters.get(channel);
        if (javaType == Boolean.TYPE) {
            ((BooleanWriteFunction)writeFunction).set(this.statement, parameterIndex, type.getBoolean(block, position));
        } else if (javaType == Long.TYPE) {
            ((LongWriteFunction)writeFunction).set(this.statement, parameterIndex, type.getLong(block, position));
        } else if (javaType == Double.TYPE) {
            ((DoubleWriteFunction)writeFunction).set(this.statement, parameterIndex, type.getDouble(block, position));
        } else if (javaType == Slice.class) {
            ((SliceWriteFunction)writeFunction).set(this.statement, parameterIndex, type.getSlice(block, position));
        } else if (javaType == Block.class) {
            ((BlockWriteFunction)writeFunction).set(this.statement, parameterIndex, (Block)type.getObject(block, position));
        } else {
            throw new VerifyException(String.format("Unexpected type %s with java type %s", type, javaType.getName()));
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        try (Connection connection = this.connection;
             PreparedStatement statement = this.statement;){
            if (this.batchSize > 0) {
                statement.executeBatch();
                connection.commit();
            }
        }
        catch (SQLNonTransientException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_NON_TRANSIENT_ERROR, (Throwable)e);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
        try (Connection connection = this.connection;
             PreparedStatement statement = this.statement;){
            if (!connection.isClosed()) {
                connection.rollback();
            }
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private static void closeWithSuppression(Connection connection, Throwable throwable) {
        block2: {
            try {
                connection.close();
            }
            catch (Throwable t) {
                if (throwable == t) break block2;
                throwable.addSuppressed(t);
            }
        }
    }
}

