/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc.credential;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationLoader;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.credential.ConfigFileBasedCredentialProvider;
import io.prestosql.plugin.jdbc.credential.CredentialConfig;
import io.prestosql.plugin.jdbc.credential.CredentialProvider;
import io.prestosql.plugin.jdbc.credential.CredentialProviderType;
import io.prestosql.plugin.jdbc.credential.ExtraCredentialProvider;
import io.prestosql.plugin.jdbc.credential.ForExtraCredentialProvider;
import io.prestosql.plugin.jdbc.credential.file.ConfigFileBasedCredentialProviderConfig;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;

public class CredentialProviderModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.bindCredentialProviderModule(CredentialProviderType.INLINE, internalBinder -> {
            ConfigBinder.configBinder((Binder)internalBinder).bindConfig(CredentialConfig.class);
            internalBinder.bind(CredentialProvider.class).annotatedWith(ForExtraCredentialProvider.class).to(ConfigFileBasedCredentialProvider.class).in(Scopes.SINGLETON);
        });
        this.bindCredentialProviderModule(CredentialProviderType.FILE, internalBinder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(ConfigFileBasedCredentialProviderConfig.class);
            internalBinder.bind(CredentialProvider.class).annotatedWith(ForExtraCredentialProvider.class).toProvider(ConfigFileBasedCredentialProviderFactory.class).in(Scopes.SINGLETON);
        });
        binder.bind(CredentialProvider.class).to(ExtraCredentialProvider.class).in(Scopes.SINGLETON);
    }

    private void bindCredentialProviderModule(CredentialProviderType name, Module module) {
        this.install(ConditionalModule.installModuleIf(BaseJdbcConfig.class, config -> name.equals((Object)config.getCredentialProviderType()), (Module)module));
    }

    private static class ConfigFileBasedCredentialProviderFactory
    implements Provider<CredentialProvider> {
        private final CredentialConfig credentialsConfig;

        @Inject
        public ConfigFileBasedCredentialProviderFactory(ConfigFileBasedCredentialProviderConfig config) throws IOException {
            Objects.requireNonNull(config, "config is null");
            Map properties = ConfigurationLoader.loadPropertiesFrom((String)config.getCredentialFile());
            this.credentialsConfig = (CredentialConfig)new ConfigurationFactory(properties).build(CredentialConfig.class);
        }

        public CredentialProvider get() {
            return new ConfigFileBasedCredentialProvider(this.credentialsConfig);
        }
    }
}

