/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.phoenix;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.DriverConnectionFactory;
import io.prestosql.plugin.jdbc.InternalBaseJdbc;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcPageSinkProvider;
import io.prestosql.plugin.jdbc.JdbcRecordSetProvider;
import io.prestosql.plugin.jdbc.credential.ConfigFileBasedCredentialProvider;
import io.prestosql.plugin.jdbc.credential.CredentialConfig;
import io.prestosql.plugin.jdbc.credential.CredentialProvider;
import io.prestosql.plugin.jdbc.credential.ExtraCredentialProvider;
import io.prestosql.plugin.phoenix.PhoenixClient;
import io.prestosql.plugin.phoenix.PhoenixColumnProperties;
import io.prestosql.plugin.phoenix.PhoenixConfig;
import io.prestosql.plugin.phoenix.PhoenixErrorCode;
import io.prestosql.plugin.phoenix.PhoenixMetadata;
import io.prestosql.plugin.phoenix.PhoenixSplitManager;
import io.prestosql.plugin.phoenix.PhoenixTableProperties;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorPageSinkProvider;
import io.prestosql.spi.connector.ConnectorRecordSetProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.type.TypeManager;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;

public class PhoenixClientModule
extends AbstractConfigurationAwareModule {
    private final TypeManager typeManager;

    public PhoenixClientModule(TypeManager typeManager) {
        this.typeManager = typeManager;
    }

    protected void setup(Binder binder) {
        binder.bind(ConnectorSplitManager.class).to(PhoenixSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorRecordSetProvider.class).to(JdbcRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(JdbcRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSinkProvider.class).to(JdbcPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(PhoenixClient.class).in(Scopes.SINGLETON);
        binder.bind(JdbcClient.class).annotatedWith(InternalBaseJdbc.class).to(PhoenixClient.class).in(Scopes.SINGLETON);
        binder.bind(PhoenixMetadata.class).in(Scopes.SINGLETON);
        binder.bind(PhoenixTableProperties.class).in(Scopes.SINGLETON);
        binder.bind(PhoenixColumnProperties.class).in(Scopes.SINGLETON);
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        this.checkConfiguration(((PhoenixConfig)this.buildConfigObject(PhoenixConfig.class)).getConnectionUrl());
    }

    private void checkConfiguration(String connectionUrl) {
        try {
            PhoenixDriver driver = PhoenixDriver.INSTANCE;
            Preconditions.checkArgument((boolean)driver.acceptsURL(connectionUrl), (Object)"Invalid JDBC URL for Phoenix connector");
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_CONFIG_ERROR, (Throwable)e);
        }
    }

    @Provides
    @Singleton
    public ConnectionFactory getConnectionFactory(PhoenixConfig config) throws SQLException {
        return new DriverConnectionFactory(DriverManager.getDriver(config.getConnectionUrl()), config.getConnectionUrl(), PhoenixClientModule.getConnectionProperties(config), (CredentialProvider)new ExtraCredentialProvider(Optional.empty(), Optional.empty(), (CredentialProvider)new ConfigFileBasedCredentialProvider(new CredentialConfig())));
    }

    public static Properties getConnectionProperties(PhoenixConfig config) throws SQLException {
        Configuration resourcesConfig = PhoenixClientModule.readConfig(config);
        Properties connectionProperties = new Properties();
        for (Map.Entry entry : resourcesConfig) {
            connectionProperties.put(entry.getKey(), entry.getValue());
        }
        PhoenixEmbeddedDriver.ConnectionInfo connectionInfo = PhoenixEmbeddedDriver.ConnectionInfo.create((String)config.getConnectionUrl());
        connectionProperties.putAll((Map<?, ?>)connectionInfo.asProps().asMap());
        return connectionProperties;
    }

    private static Configuration readConfig(PhoenixConfig config) {
        Configuration result = new Configuration(false);
        for (String resourcePath : config.getResourceConfigFiles()) {
            result.addResource(new Path(resourcePath));
        }
        return result;
    }
}

