/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.phoenix;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.json.JsonModule;
import io.prestosql.plugin.phoenix.PhoenixClientModule;
import io.prestosql.plugin.phoenix.PhoenixColumnProperties;
import io.prestosql.plugin.phoenix.PhoenixConnector;
import io.prestosql.plugin.phoenix.PhoenixHandleResolver;
import io.prestosql.plugin.phoenix.PhoenixMetadata;
import io.prestosql.plugin.phoenix.PhoenixTableProperties;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorPageSinkProvider;
import io.prestosql.spi.connector.ConnectorRecordSetProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.classloader.ClassLoaderSafeConnectorMetadata;
import io.prestosql.spi.connector.classloader.ClassLoaderSafeConnectorPageSinkProvider;
import io.prestosql.spi.connector.classloader.ClassLoaderSafeConnectorSplitManager;
import java.util.Map;
import java.util.Objects;

public class PhoenixConnectorFactory
implements ConnectorFactory {
    private final ClassLoader classLoader;

    public PhoenixConnectorFactory(ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public String getName() {
        return "phoenix";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new PhoenixHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> requiredConfig, ConnectorContext context) {
        Objects.requireNonNull(requiredConfig, "requiredConfig is null");
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new PhoenixClientModule(context.getTypeManager())});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).initialize();
            LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            PhoenixMetadata metadata = (PhoenixMetadata)injector.getInstance(PhoenixMetadata.class);
            ConnectorSplitManager splitManager = (ConnectorSplitManager)injector.getInstance(ConnectorSplitManager.class);
            ConnectorRecordSetProvider recordSetProvider = (ConnectorRecordSetProvider)injector.getInstance(ConnectorRecordSetProvider.class);
            ConnectorPageSinkProvider pageSinkProvider = (ConnectorPageSinkProvider)injector.getInstance(ConnectorPageSinkProvider.class);
            PhoenixTableProperties tableProperties = (PhoenixTableProperties)injector.getInstance(PhoenixTableProperties.class);
            PhoenixColumnProperties columnProperties = (PhoenixColumnProperties)injector.getInstance(PhoenixColumnProperties.class);
            PhoenixConnector phoenixConnector = new PhoenixConnector(lifeCycleManager, (ConnectorMetadata)new ClassLoaderSafeConnectorMetadata((ConnectorMetadata)metadata, this.classLoader), (ConnectorSplitManager)new ClassLoaderSafeConnectorSplitManager(splitManager, this.classLoader), recordSetProvider, (ConnectorPageSinkProvider)new ClassLoaderSafeConnectorPageSinkProvider(pageSinkProvider, this.classLoader), tableProperties, columnProperties);
            return phoenixConnector;
        }
    }
}

