/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.phoenix;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.plugin.phoenix.PhoenixClient;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.Chars;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spi.type.Varchars;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.sql.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static String getArrayElementPhoenixTypeName(ConnectorSession session, PhoenixClient client, Type elementType) {
        if (Varchars.isVarcharType((Type)elementType)) {
            return "VARCHAR";
        }
        if (Chars.isCharType((Type)elementType)) {
            return "CHAR";
        }
        if (elementType instanceof DecimalType) {
            return "DECIMAL";
        }
        return client.toWriteMapping(session, elementType).getDataType().toUpperCase();
    }

    public static Block jdbcObjectArrayToBlock(ConnectorSession session, Type type, Object[] elements) {
        BlockBuilder builder = type.createBlockBuilder(null, elements.length);
        for (Object element : elements) {
            io.prestosql.spi.type.TypeUtils.writeNativeValue((Type)type, (BlockBuilder)builder, (Object)TypeUtils.jdbcObjectToPrestoNative(session, element, type));
        }
        return builder.build();
    }

    public static Object[] getJdbcObjectArray(ConnectorSession session, Type elementType, Block block) {
        int positionCount = block.getPositionCount();
        Object[] valuesArray = new Object[positionCount];
        int subArrayLength = 1;
        for (int i = 0; i < positionCount; ++i) {
            Object objectValue;
            valuesArray[i] = objectValue = TypeUtils.prestoNativeToJdbcObject(session, elementType, io.prestosql.spi.type.TypeUtils.readNativeValue((Type)elementType, (Block)block, (int)i));
            if (objectValue == null || !objectValue.getClass().isArray()) continue;
            subArrayLength = Math.max(subArrayLength, Array.getLength(objectValue));
        }
        if (elementType instanceof ArrayType) {
            TypeUtils.handleArrayNulls(valuesArray, subArrayLength);
        }
        return valuesArray;
    }

    public static Object[] toBoxedArray(Object jdbcArray) {
        Objects.requireNonNull(jdbcArray, "jdbcArray is null");
        Preconditions.checkArgument((boolean)jdbcArray.getClass().isArray(), (String)"object is not an array: %s", (Object)jdbcArray.getClass().getName());
        if (!jdbcArray.getClass().getComponentType().isPrimitive()) {
            return (Object[])jdbcArray;
        }
        int elementCount = Array.getLength(jdbcArray);
        Object[] elements = new Object[elementCount];
        for (int i = 0; i < elementCount; ++i) {
            elements[i] = Array.get(jdbcArray, i);
        }
        return elements;
    }

    private static void handleArrayNulls(Object[] valuesArray, int length) {
        for (int i = 0; i < valuesArray.length; ++i) {
            if (valuesArray[i] != null) continue;
            valuesArray[i] = new Object[length];
        }
    }

    private static Object jdbcObjectToPrestoNative(ConnectorSession session, Object jdbcObject, Type prestoType) {
        if (jdbcObject == null) {
            return null;
        }
        if (BooleanType.BOOLEAN.equals((Object)prestoType) || TinyintType.TINYINT.equals((Object)prestoType) || SmallintType.SMALLINT.equals((Object)prestoType) || IntegerType.INTEGER.equals((Object)prestoType) || BigintType.BIGINT.equals((Object)prestoType) || DoubleType.DOUBLE.equals((Object)prestoType)) {
            return jdbcObject;
        }
        if (prestoType instanceof ArrayType) {
            return TypeUtils.jdbcObjectArrayToBlock(session, ((ArrayType)prestoType).getElementType(), (Object[])jdbcObject);
        }
        if (prestoType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)prestoType;
            BigDecimal value = (BigDecimal)jdbcObject;
            if (decimalType.isShort()) {
                return Decimals.encodeShortScaledValue((BigDecimal)value, (int)decimalType.getScale());
            }
            return Decimals.encodeScaledValue((BigDecimal)value, (int)decimalType.getScale());
        }
        if (RealType.REAL.equals((Object)prestoType)) {
            return Float.floatToRawIntBits(((Float)jdbcObject).floatValue());
        }
        if (DateType.DATE.equals((Object)prestoType)) {
            long localMillis = ((Date)jdbcObject).getTime();
            long utcMillis = ISOChronology.getInstance().getZone().getMillisKeepLocal(DateTimeZone.UTC, localMillis);
            return TimeUnit.MILLISECONDS.toDays(utcMillis);
        }
        if (prestoType instanceof VarcharType) {
            return Slices.utf8Slice((String)((String)jdbcObject));
        }
        if (prestoType instanceof CharType) {
            return Slices.utf8Slice((String)CharMatcher.is((char)' ').trimTrailingFrom((CharSequence)((String)jdbcObject)));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported type %s and object type %s", prestoType, jdbcObject.getClass()));
    }

    private static Object prestoNativeToJdbcObject(ConnectorSession session, Type prestoType, Object prestoNative) {
        if (prestoNative == null) {
            return null;
        }
        if (DoubleType.DOUBLE.equals((Object)prestoType) || BooleanType.BOOLEAN.equals((Object)prestoType) || BigintType.BIGINT.equals((Object)prestoType)) {
            return prestoNative;
        }
        if (prestoType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)prestoType;
            if (decimalType.isShort()) {
                BigInteger unscaledValue = BigInteger.valueOf((Long)prestoNative);
                return new BigDecimal(unscaledValue, decimalType.getScale(), new MathContext(decimalType.getPrecision()));
            }
            BigInteger unscaledValue = Decimals.decodeUnscaledValue((Slice)((Slice)prestoNative));
            return new BigDecimal(unscaledValue, decimalType.getScale(), new MathContext(decimalType.getPrecision()));
        }
        if (RealType.REAL.equals((Object)prestoType)) {
            return Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)prestoNative)));
        }
        if (TinyintType.TINYINT.equals((Object)prestoType)) {
            return SignedBytes.checkedCast((long)((Long)prestoNative));
        }
        if (SmallintType.SMALLINT.equals((Object)prestoType)) {
            return Shorts.checkedCast((long)((Long)prestoNative));
        }
        if (IntegerType.INTEGER.equals((Object)prestoType)) {
            return Math.toIntExact((Long)prestoNative);
        }
        if (DateType.DATE.equals((Object)prestoType)) {
            long millis = TimeUnit.DAYS.toMillis((Long)prestoNative);
            return new Date(DateTimeZone.UTC.getMillisKeepLocal(DateTimeZone.getDefault(), millis));
        }
        if (prestoType instanceof VarcharType || prestoType instanceof CharType) {
            return ((Slice)prestoNative).toStringUtf8();
        }
        if (prestoType instanceof ArrayType) {
            return TypeUtils.getJdbcObjectArray(session, ((ArrayType)prestoType).getElementType(), (Block)prestoNative);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type: " + prestoType);
    }
}

