/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.classloader;

import io.prestosql.plugin.base.classloader.ForClassLoaderSafe;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorSecurityContext;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class ClassLoaderSafeConnectorAccessControl
implements ConnectorAccessControl {
    private final ConnectorAccessControl delegate;
    private final ClassLoader classLoader;

    @Inject
    public ClassLoaderSafeConnectorAccessControl(@ForClassLoaderSafe ConnectorAccessControl delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public void checkCanCreateSchema(ConnectorSecurityContext context, String schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanCreateSchema(context, schemaName);
        }
    }

    public void checkCanDropSchema(ConnectorSecurityContext context, String schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanDropSchema(context, schemaName);
        }
    }

    public void checkCanRenameSchema(ConnectorSecurityContext context, String schemaName, String newSchemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanRenameSchema(context, schemaName, newSchemaName);
        }
    }

    public void checkCanShowSchemas(ConnectorSecurityContext context) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanShowSchemas(context);
        }
    }

    public Set<String> filterSchemas(ConnectorSecurityContext context, Set<String> schemaNames) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set set = this.delegate.filterSchemas(context, schemaNames);
            return set;
        }
    }

    public void checkCanCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanCreateTable(context, tableName);
        }
    }

    public void checkCanDropTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanDropTable(context, tableName);
        }
    }

    public void checkCanRenameTable(ConnectorSecurityContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanRenameTable(context, tableName, newTableName);
        }
    }

    public void checkCanSetTableComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanSetTableComment(context, tableName);
        }
    }

    public void checkCanShowTablesMetadata(ConnectorSecurityContext context, String schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanShowTablesMetadata(context, schemaName);
        }
    }

    public Set<SchemaTableName> filterTables(ConnectorSecurityContext context, Set<SchemaTableName> tableNames) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set set = this.delegate.filterTables(context, tableNames);
            return set;
        }
    }

    public void checkCanShowColumnsMetadata(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanShowColumnsMetadata(context, tableName);
        }
    }

    public List<ColumnMetadata> filterColumns(ConnectorSecurityContext context, SchemaTableName tableName, List<ColumnMetadata> columns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.filterColumns(context, tableName, columns);
            return list;
        }
    }

    public void checkCanAddColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanAddColumn(context, tableName);
        }
    }

    public void checkCanDropColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanDropColumn(context, tableName);
        }
    }

    public void checkCanRenameColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanRenameColumn(context, tableName);
        }
    }

    public void checkCanSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanSelectFromColumns(context, tableName, columnNames);
        }
    }

    public void checkCanInsertIntoTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanInsertIntoTable(context, tableName);
        }
    }

    public void checkCanDeleteFromTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanDeleteFromTable(context, tableName);
        }
    }

    public void checkCanCreateView(ConnectorSecurityContext context, SchemaTableName viewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanCreateView(context, viewName);
        }
    }

    public void checkCanRenameView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanRenameView(context, viewName, newViewName);
        }
    }

    public void checkCanDropView(ConnectorSecurityContext context, SchemaTableName viewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanDropView(context, viewName);
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanCreateViewWithSelectFromColumns(context, tableName, columnNames);
        }
    }

    public void checkCanSetCatalogSessionProperty(ConnectorSecurityContext context, String propertyName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanSetCatalogSessionProperty(context, propertyName);
        }
    }

    public void checkCanGrantTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal grantee, boolean withGrantOption) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanGrantTablePrivilege(context, privilege, tableName, grantee, withGrantOption);
        }
    }

    public void checkCanRevokeTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal revokee, boolean grantOptionFor) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanRevokeTablePrivilege(context, privilege, tableName, revokee, grantOptionFor);
        }
    }

    public void checkCanCreateRole(ConnectorSecurityContext context, String role, Optional<PrestoPrincipal> grantor) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanCreateRole(context, role, grantor);
        }
    }

    public void checkCanDropRole(ConnectorSecurityContext context, String role) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanDropRole(context, role);
        }
    }

    public void checkCanGrantRoles(ConnectorSecurityContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanGrantRoles(context, roles, grantees, withAdminOption, grantor, catalogName);
        }
    }

    public void checkCanRevokeRoles(ConnectorSecurityContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor, String catalogName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanRevokeRoles(context, roles, grantees, adminOptionFor, grantor, catalogName);
        }
    }

    public void checkCanSetRole(ConnectorSecurityContext context, String role, String catalogName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanSetRole(context, role, catalogName);
        }
    }

    public void checkCanShowRoles(ConnectorSecurityContext context, String catalogName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanShowRoles(context, catalogName);
        }
    }

    public void checkCanShowCurrentRoles(ConnectorSecurityContext context, String catalogName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanShowCurrentRoles(context, catalogName);
        }
    }

    public void checkCanShowRoleGrants(ConnectorSecurityContext context, String catalogName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.checkCanShowRoleGrants(context, catalogName);
        }
    }
}

