/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.base.security.AccessControlRules;
import io.prestosql.plugin.base.security.FileBasedAccessControlConfig;
import io.prestosql.plugin.base.security.SchemaAccessControlRule;
import io.prestosql.plugin.base.security.SessionPropertyAccessControlRule;
import io.prestosql.plugin.base.security.TableAccessControlRule;
import io.prestosql.plugin.base.util.JsonUtils;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorSecurityContext;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.ConnectorIdentity;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class FileBasedAccessControl
implements ConnectorAccessControl {
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private final List<SchemaAccessControlRule> schemaRules;
    private final List<TableAccessControlRule> tableRules;
    private final List<SessionPropertyAccessControlRule> sessionPropertyRules;

    @Inject
    public FileBasedAccessControl(FileBasedAccessControlConfig config) {
        AccessControlRules rules = JsonUtils.parseJson(Paths.get(config.getConfigFile(), new String[0]), AccessControlRules.class);
        this.schemaRules = rules.getSchemaRules();
        this.tableRules = rules.getTableRules();
        this.sessionPropertyRules = rules.getSessionPropertyRules();
    }

    public void checkCanCreateSchema(ConnectorSecurityContext context, String schemaName) {
        if (!this.isSchemaOwner(context, schemaName)) {
            AccessDeniedException.denyCreateSchema((String)schemaName);
        }
    }

    public void checkCanDropSchema(ConnectorSecurityContext context, String schemaName) {
        if (!this.isSchemaOwner(context, schemaName)) {
            AccessDeniedException.denyDropSchema((String)schemaName);
        }
    }

    public void checkCanRenameSchema(ConnectorSecurityContext context, String schemaName, String newSchemaName) {
        if (!this.isSchemaOwner(context, schemaName) || !this.isSchemaOwner(context, newSchemaName)) {
            AccessDeniedException.denyRenameSchema((String)schemaName, (String)newSchemaName);
        }
    }

    public void checkCanShowSchemas(ConnectorSecurityContext context) {
    }

    public Set<String> filterSchemas(ConnectorSecurityContext context, Set<String> schemaNames) {
        return schemaNames;
    }

    public void checkCanCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.isSchemaOwner(context, tableName.getSchemaName())) {
            AccessDeniedException.denyCreateTable((String)tableName.toString());
        }
    }

    public void checkCanDropTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
    }

    public void checkCanShowTablesMetadata(ConnectorSecurityContext context, String schemaName) {
    }

    public Set<SchemaTableName> filterTables(ConnectorSecurityContext context, Set<SchemaTableName> tableNames) {
        return tableNames;
    }

    public void checkCanShowColumnsMetadata(ConnectorSecurityContext identity, SchemaTableName tableName) {
    }

    public List<ColumnMetadata> filterColumns(ConnectorSecurityContext identity, SchemaTableName tableName, List<ColumnMetadata> columns) {
        return columns;
    }

    public void checkCanRenameTable(ConnectorSecurityContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP) || !this.checkTablePermission(context, newTableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
    }

    public void checkCanSetTableComment(ConnectorSecurityContext identity, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyCommentTable((String)tableName.toString());
        }
    }

    public void checkCanAddColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
    }

    public void checkCanDropColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropColumn((String)tableName.toString());
        }
    }

    public void checkCanRenameColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
    }

    public void checkCanSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.SELECT)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
    }

    public void checkCanInsertIntoTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.INSERT)) {
            AccessDeniedException.denyInsertTable((String)tableName.toString());
        }
    }

    public void checkCanDeleteFromTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.DELETE)) {
            AccessDeniedException.denyDeleteTable((String)tableName.toString());
        }
    }

    public void checkCanCreateView(ConnectorSecurityContext context, SchemaTableName viewName) {
        if (!this.isSchemaOwner(context, viewName.getSchemaName())) {
            AccessDeniedException.denyCreateView((String)viewName.toString());
        }
    }

    public void checkCanRenameView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        if (!this.checkTablePermission(context, viewName, TableAccessControlRule.TablePrivilege.OWNERSHIP) || !this.checkTablePermission(context, newViewName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameView((String)viewName.toString(), (String)newViewName.toString());
        }
    }

    public void checkCanDropView(ConnectorSecurityContext context, SchemaTableName viewName) {
        if (!this.checkTablePermission(context, viewName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropView((String)viewName.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.SELECT)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.GRANT_SELECT)) {
            AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString(), (ConnectorIdentity)context.getIdentity());
        }
    }

    public void checkCanSetCatalogSessionProperty(ConnectorSecurityContext context, String propertyName) {
        if (!this.canSetSessionProperty(context, propertyName)) {
            AccessDeniedException.denySetCatalogSessionProperty((String)propertyName);
        }
    }

    public void checkCanGrantTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal grantee, boolean withGrantOption) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    public void checkCanRevokeTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal revokee, boolean grantOptionFor) {
        if (!this.checkTablePermission(context, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRevokeTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    public void checkCanCreateRole(ConnectorSecurityContext context, String role, Optional<PrestoPrincipal> grantor) {
    }

    public void checkCanDropRole(ConnectorSecurityContext context, String role) {
    }

    public void checkCanGrantRoles(ConnectorSecurityContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
    }

    public void checkCanRevokeRoles(ConnectorSecurityContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor, String catalogName) {
    }

    public void checkCanSetRole(ConnectorSecurityContext context, String role, String catalogName) {
    }

    public void checkCanShowRoles(ConnectorSecurityContext context, String catalogName) {
    }

    public void checkCanShowCurrentRoles(ConnectorSecurityContext context, String catalogName) {
    }

    public void checkCanShowRoleGrants(ConnectorSecurityContext context, String catalogName) {
    }

    private boolean canSetSessionProperty(ConnectorSecurityContext context, String property) {
        for (SessionPropertyAccessControlRule rule : this.sessionPropertyRules) {
            Optional<Boolean> allowed = rule.match(context.getIdentity().getUser(), property);
            if (!allowed.isPresent()) continue;
            return allowed.get();
        }
        return false;
    }

    private boolean checkTablePermission(ConnectorSecurityContext context, SchemaTableName tableName, TableAccessControlRule.TablePrivilege ... requiredPrivileges) {
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return true;
        }
        for (TableAccessControlRule rule : this.tableRules) {
            Optional<Set<TableAccessControlRule.TablePrivilege>> tablePrivileges = rule.match(context.getIdentity().getUser(), tableName);
            if (!tablePrivileges.isPresent()) continue;
            return tablePrivileges.get().containsAll((Collection<?>)ImmutableSet.copyOf((Object[])requiredPrivileges));
        }
        return false;
    }

    private boolean isSchemaOwner(ConnectorSecurityContext context, String schemaName) {
        for (SchemaAccessControlRule rule : this.schemaRules) {
            Optional<Boolean> owner = rule.match(context.getIdentity().getUser(), schemaName);
            if (!owner.isPresent()) continue;
            return owner.get();
        }
        return false;
    }
}

