/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.base.security.CatalogAccessControlRule;
import io.prestosql.plugin.base.security.ImpersonationRule;
import io.prestosql.plugin.base.security.PrincipalUserMatchRule;
import java.util.List;
import java.util.Optional;

public class FileBasedSystemAccessControlRules {
    private final List<CatalogAccessControlRule> catalogRules;
    private final Optional<List<ImpersonationRule>> impersonationRules;
    private final Optional<List<PrincipalUserMatchRule>> principalUserMatchRules;

    @JsonCreator
    public FileBasedSystemAccessControlRules(@JsonProperty(value="catalogs") Optional<List<CatalogAccessControlRule>> catalogRules, @JsonProperty(value="impersonation") Optional<List<ImpersonationRule>> impersonationRules, @JsonProperty(value="principals") Optional<List<PrincipalUserMatchRule>> principalUserMatchRules) {
        this.catalogRules = (List)catalogRules.map(ImmutableList::copyOf).orElse(ImmutableList.of());
        this.principalUserMatchRules = principalUserMatchRules.map(ImmutableList::copyOf);
        this.impersonationRules = impersonationRules.map(ImmutableList::copyOf);
    }

    public List<CatalogAccessControlRule> getCatalogRules() {
        return this.catalogRules;
    }

    public Optional<List<ImpersonationRule>> getImpersonationRules() {
        return this.impersonationRules;
    }

    public Optional<List<PrincipalUserMatchRule>> getPrincipalUserMatchRules() {
        return this.principalUserMatchRules;
    }
}

