/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorSecurityContext;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import java.util.List;
import java.util.Set;

public class ReadOnlyAccessControl
implements ConnectorAccessControl {
    public void checkCanShowSchemas(ConnectorSecurityContext context) {
    }

    public Set<String> filterSchemas(ConnectorSecurityContext context, Set<String> schemaNames) {
        return schemaNames;
    }

    public void checkCanAddColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyAddColumn((String)tableName.toString());
    }

    public void checkCanDropColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyDropColumn((String)tableName.toString());
    }

    public void checkCanCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyCreateTable((String)tableName.toString());
    }

    public void checkCanDropTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyDropTable((String)tableName.toString());
    }

    public void checkCanRenameTable(ConnectorSecurityContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
    }

    public void checkCanSetTableComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyCommentTable((String)tableName.toString());
    }

    public void checkCanShowTablesMetadata(ConnectorSecurityContext context, String schemaName) {
    }

    public Set<SchemaTableName> filterTables(ConnectorSecurityContext context, Set<SchemaTableName> tableNames) {
        return tableNames;
    }

    public void checkCanShowColumnsMetadata(ConnectorSecurityContext context, SchemaTableName tableName) {
    }

    public List<ColumnMetadata> filterColumns(ConnectorSecurityContext context, SchemaTableName tableName, List<ColumnMetadata> columns) {
        return columns;
    }

    public void checkCanRenameColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyRenameColumn((String)tableName.toString());
    }

    public void checkCanSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
    }

    public void checkCanInsertIntoTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyInsertTable((String)tableName.toString());
    }

    public void checkCanDeleteFromTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyDeleteTable((String)tableName.toString());
    }

    public void checkCanCreateView(ConnectorSecurityContext context, SchemaTableName viewName) {
        AccessDeniedException.denyCreateView((String)viewName.toString());
    }

    public void checkCanRenameView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        AccessDeniedException.denyRenameView((String)viewName.toString(), (String)newViewName.toString());
    }

    public void checkCanDropView(ConnectorSecurityContext context, SchemaTableName viewName) {
        AccessDeniedException.denyDropView((String)viewName.toString());
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
    }

    public void checkCanSetCatalogSessionProperty(ConnectorSecurityContext context, String propertyName) {
    }

    public void checkCanGrantTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal grantee, boolean withGrantOption) {
        AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)tableName.toString());
    }

    public void checkCanRevokeTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal revokee, boolean grantOptionFor) {
        AccessDeniedException.denyRevokeTablePrivilege((String)privilege.name(), (String)tableName.toString());
    }

    public void checkCanShowRoles(ConnectorSecurityContext context, String catalogName) {
    }

    public void checkCanShowCurrentRoles(ConnectorSecurityContext context, String catalogName) {
    }

    public void checkCanShowRoleGrants(ConnectorSecurityContext context, String catalogName) {
    }
}

